/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPropertyTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(GetPropertyTest.class);
    private String node1Path;
    private String prop1Path;
    private String prop2Path;
    private Session readOnly;

    protected void setUp() throws Exception {
        super.setUp();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.node1Path = n.getPath();
        Property p = n.setProperty(this.propertyName1, "string1");
        this.prop1Path = p.getPath();
        p = n.setProperty(this.propertyName2, "string2");
        this.prop2Path = p.getPath();
        this.testRootNode.save();
        this.readOnly = this.getHelper().getReadOnlySession();
    }

    protected void tearDown() throws Exception {
        if (this.readOnly != null) {
            this.readOnly.logout();
            this.readOnly = null;
        }
        super.tearDown();
    }

    public void testItemExists() throws RepositoryException {
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(this.prop1Path));
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(this.prop2Path));
    }

    public void testGetItem() throws RepositoryException {
        GetPropertyTest.assertFalse((boolean)this.readOnly.getItem(this.prop1Path).isNode());
        GetPropertyTest.assertFalse((boolean)this.readOnly.getItem(this.prop2Path).isNode());
    }

    public void testHasProperty() throws RepositoryException {
        String testPath = this.testRootNode.getPath();
        Node trn = (Node)this.readOnly.getItem(testPath);
        GetPropertyTest.assertTrue((boolean)trn.hasProperty(this.prop1Path.substring(testPath.length() + 1)));
        GetPropertyTest.assertTrue((boolean)trn.hasProperty(this.prop2Path.substring(testPath.length() + 1)));
    }

    public void testGetProperty() throws RepositoryException {
        String testPath = this.testRootNode.getPath();
        Node trn = (Node)this.readOnly.getItem(testPath);
        trn.getProperty(this.prop1Path.substring(testPath.length() + 1));
        trn.getProperty(this.prop2Path.substring(testPath.length() + 1));
    }

    public void testGetDeepProperty() throws RepositoryException {
        Node n2 = this.testRootNode.getNode(this.nodeName1).addNode(this.nodeName2);
        this.testRootNode.save();
        Node node2 = (Node)this.readOnly.getItem(n2.getPath());
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(this.prop1Path));
        Property p1 = (Property)this.readOnly.getItem(this.prop1Path);
        GetPropertyTest.assertTrue((boolean)p1.isSame((Item)node2.getProperty("../" + Text.getName((String)this.prop1Path))));
        PropertyIterator it = node2.getParent().getProperties();
        GetPropertyTest.assertTrue((it.getSize() >= 3L ? 1 : 0) != 0);
    }

    public void testGetExternallyAddedItems() throws RepositoryException {
        Node node1 = (Node)this.readOnly.getItem(this.node1Path);
        Node n2 = this.testRootNode.getNode(this.nodeName1).addNode(this.nodeName2);
        Property p3 = n2.setProperty(this.propertyName1, "test");
        this.testRootNode.save();
        node1.refresh(true);
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(n2.getPath()));
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(p3.getPath()));
    }

    public void testGetExternallyChangedNode() throws RepositoryException {
        Node node1 = (Node)this.readOnly.getItem(this.node1Path);
        Node n2 = this.testRootNode.getNode(this.nodeName1).addNode(this.nodeName2);
        Property p3 = n2.setProperty(this.propertyName1, "test");
        this.testRootNode.save();
        node1.refresh(false);
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(n2.getPath()));
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(p3.getPath()));
        Item m2 = this.readOnly.getItem(n2.getPath());
        GetPropertyTest.assertTrue((boolean)m2.isNode());
        GetPropertyTest.assertTrue((boolean)((Node)m2).hasProperty(this.propertyName1));
        p3.remove();
        this.testRootNode.save();
        node1.refresh(false);
        GetPropertyTest.assertFalse((boolean)((Node)m2).hasProperty(this.propertyName1));
    }

    public void testGetExternallyChangedProperty() throws RepositoryException {
        Node node1 = (Node)this.readOnly.getItem(this.node1Path);
        Node n2 = this.testRootNode.getNode(this.nodeName1).addNode(this.nodeName2);
        Property p3 = n2.setProperty(this.propertyName1, "test");
        p3.setValue("v3");
        this.testRootNode.save();
        node1.refresh(false);
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(n2.getPath()));
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(p3.getPath()));
        Item q3 = this.readOnly.getItem(p3.getPath());
        GetPropertyTest.assertFalse((boolean)q3.isNode());
        GetPropertyTest.assertTrue((boolean)"v3".equals(((Property)q3).getString()));
        p3.setValue("v3_modified");
        this.testRootNode.save();
        node1.refresh(false);
        GetPropertyTest.assertTrue((boolean)"v3_modified".equals(((Property)q3).getString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDeepSNSProperties() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.getNode(this.nodeName1);
        if (!n.getDefinition().allowsSameNameSiblings()) {
            throw new NotExecutableException();
        }
        Node sib2 = this.testRootNode.addNode(this.nodeName1);
        Property p2 = sib2.setProperty(this.propertyName1, "sib2-prop");
        Node sib3 = this.testRootNode.addNode(this.nodeName1);
        Property p3 = sib3.setProperty(this.propertyName1, "sib3-prop");
        this.testRootNode.save();
        Session s = this.getHelper().getReadWriteSession();
        try {
            Node sibNode = (Node)s.getItem(sib2.getPath());
            sibNode.remove();
            Property pp3 = (Property)s.getItem(sib2.getPath() + "/" + this.propertyName1);
            GetPropertyTest.assertEquals((String)"sib3-prop", (String)pp3.getString());
            GetPropertyTest.assertFalse((boolean)s.itemExists(p3.getPath()));
            GetPropertyTest.assertFalse((boolean)s.itemExists(sib3.getPath()));
        }
        finally {
            s.logout();
        }
    }

    public void testGetDeepRefNodeProperties() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.getNode(this.nodeName1);
        n.addMixin(this.mixReferenceable);
        Node n2 = n.addNode(this.nodeName2);
        Property p3 = n2.setProperty(this.propertyName1, "test");
        this.testRootNode.save();
        Property prop3 = (Property)this.readOnly.getItem(p3.getPath());
        GetPropertyTest.assertTrue((boolean)this.readOnly.itemExists(this.prop2Path));
        Property p1 = (Property)this.readOnly.getItem(this.prop2Path);
        Node node1 = this.readOnly.getNodeByUUID(n.getUUID());
        GetPropertyTest.assertTrue((boolean)p1.isSame((Item)node1.getProperty(Text.getName((String)this.prop2Path))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPropertyOfRemovedAncestor() throws RepositoryException {
        Session rw = this.getHelper().getReadWriteSession();
        try {
            Property p = (Property)rw.getItem(this.prop1Path);
            p.setValue("changedValue");
            rw.getItem(this.testRootNode.getPath()).remove();
            try {
                p.getValue();
                GetPropertyTest.fail((String)"modified property must be marked removed upon parent removal");
            }
            catch (InvalidItemStateException invalidItemStateException) {
                // empty catch block
            }
            try {
                rw.getItem(this.prop1Path);
                GetPropertyTest.fail((String)"modified property must be marked removed upon parent removal");
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            try {
                Property p2 = (Property)rw.getItem(this.prop2Path);
                GetPropertyTest.fail((String)"existing property must be marked removed upon parent removal");
            }
            catch (PathNotFoundException p2) {
                // empty catch block
            }
            rw.refresh(false);
            Property pAgain = (Property)rw.getItem(this.prop1Path);
            GetPropertyTest.assertTrue((boolean)p.isSame((Item)pAgain));
            GetPropertyTest.assertEquals((String)"string1", (String)p.getString());
        }
        finally {
            rw.logout();
        }
    }

    public void testGetDeepEmptyStringProperty() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.getNode(this.nodeName1);
        Node n2 = n.addNode(this.nodeName2);
        Node n3 = n2.addNode(this.nodeName3);
        Node n4 = n3.addNode(this.nodeName4);
        Property emptyProp = n4.setProperty(this.propertyName1, "");
        this.testRootNode.save();
        Property p = this.readOnly.getProperty(emptyProp.getPath());
        GetPropertyTest.assertEquals((String)"", (String)p.getString());
    }
}

