/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class HierarchyNodeTest
extends AbstractJCRTest {
    private final Set<String> hierarchyNodeProps = new HashSet<String>();
    private final Set<String> resourceProps = new HashSet<String>();
    private String ntFolder;
    private String ntFile;
    private String ntResource;
    private Node fileNode;

    protected void setUp() throws Exception {
        super.setUp();
        Session s = this.testRootNode.getSession();
        String jcrPrefix = s.getNamespacePrefix("http://www.jcp.org/jcr/1.0");
        String ntPrefix = s.getNamespacePrefix("http://www.jcp.org/jcr/nt/1.0");
        this.ntFolder = ntPrefix + ":folder";
        this.ntFile = ntPrefix + ":file";
        this.ntResource = ntPrefix + ":resource";
        this.hierarchyNodeProps.add(jcrPrefix + ":primaryType");
        this.hierarchyNodeProps.add(jcrPrefix + ":created");
        this.hierarchyNodeProps.add(jcrPrefix + ":createdBy");
        this.resourceProps.add(jcrPrefix + ":primaryType");
        this.resourceProps.add(jcrPrefix + ":lastModified");
        this.resourceProps.add(jcrPrefix + ":lastModifiedBy");
        this.resourceProps.add(jcrPrefix + ":mimeType");
        this.resourceProps.add(jcrPrefix + ":data");
        this.resourceProps.add(jcrPrefix + ":uuid");
        try {
            Node folder = this.testRootNode.addNode("folder", this.ntFolder);
            this.fileNode = folder.addNode("file", this.ntFile);
            Node content = this.fileNode.addNode(jcrPrefix + ":content", this.ntResource);
            content.setProperty(jcrPrefix + ":mimeType", "text/plain");
            content.setProperty(jcrPrefix + ":data", "some plain text");
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Cannot create hierarchy nodes.");
        }
    }

    protected void tearDown() throws Exception {
        this.fileNode = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetProperties() throws RepositoryException {
        Session readSession = this.getHelper().getReadOnlySession();
        try {
            this.dump((Node)readSession.getItem(this.fileNode.getPath()));
        }
        finally {
            readSession.logout();
        }
    }

    private void dump(Node node) throws RepositoryException {
        PropertyIterator properties = node.getProperties();
        HashSet<String> set = new HashSet<String>();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            set.add(property.getName());
        }
        if (node.getPrimaryNodeType().getName().equals(this.ntFolder)) {
            HierarchyNodeTest.assertTrue((this.hierarchyNodeProps.size() == set.size() && this.hierarchyNodeProps.containsAll(set) ? 1 : 0) != 0);
        } else if (node.getPrimaryNodeType().getName().equals(this.ntFile)) {
            HierarchyNodeTest.assertTrue((this.hierarchyNodeProps.size() == set.size() && this.hierarchyNodeProps.containsAll(set) ? 1 : 0) != 0);
        } else if (node.getPrimaryNodeType().getName().equals(this.ntResource)) {
            HierarchyNodeTest.assertTrue((this.resourceProps.size() == set.size() && this.resourceProps.containsAll(set) ? 1 : 0) != 0);
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            this.dump(nodes.nextNode());
        }
    }
}

