/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsSameTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(IsSameTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameProperty() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyvalue");
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Property otherProperty = (Property)otherSession.getItem(p.getPath());
            IsSameTest.assertTrue((boolean)p.isSame((Item)otherProperty));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameProperty2() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyvalue");
        this.testRootNode.save();
        p.setValue("someOtherValue");
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Property otherProperty = (Property)otherSession.getItem(p.getPath());
            IsSameTest.assertTrue((boolean)p.isSame((Item)otherProperty));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameProperty3() throws RepositoryException {
        Node n = this.testRootNode.addNode("aFile", "nt:file");
        n = n.addNode("jcr:content", "nt:resource");
        n.setProperty("jcr:lastModified", Calendar.getInstance());
        n.setProperty("jcr:mimeType", "text/plain");
        Property jcrData = n.setProperty("jcr:data", "abc", 2);
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Property otherProperty = (Property)otherSession.getItem(jcrData.getPath());
            IsSameTest.assertTrue((boolean)jcrData.isSame((Item)otherProperty));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameProperty4() throws RepositoryException {
        Node n = this.testRootNode.addNode("aFile", "nt:file");
        n = n.addNode("jcr:content", "nt:resource");
        n.setProperty("jcr:lastModified", Calendar.getInstance());
        n.setProperty("jcr:mimeType", "text/plain");
        Property jcrData = n.setProperty("jcr:data", "abc", 2);
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Property otherProperty = (Property)otherSession.getItem(jcrData.getPath());
            IsSameTest.assertTrue((boolean)n.getProperty("jcr:data").isSame((Item)otherProperty));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameNode() throws RepositoryException {
        Node n = this.testRootNode.addNode("aFile", "nt:file");
        n = n.addNode("jcr:content", "nt:resource");
        n.setProperty("jcr:lastModified", Calendar.getInstance());
        n.setProperty("jcr:mimeType", "text/plain");
        n.setProperty("jcr:data", "abc", 2);
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node otherNode = (Node)otherSession.getItem(n.getPath());
            IsSameTest.assertTrue((boolean)n.isSame((Item)otherNode));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameNode2() throws RepositoryException {
        Node n = this.testRootNode.addNode("aFile", "nt:file");
        n = n.addNode("jcr:content", "nt:resource");
        n.setProperty("jcr:lastModified", Calendar.getInstance());
        n.setProperty("jcr:mimeType", "text/plain");
        n.setProperty("jcr:data", "abc", 2);
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node otherNode = (Node)otherSession.getItem(n.getPath());
            IsSameTest.assertTrue((boolean)otherNode.isSame((Item)n));
        }
        finally {
            otherSession.logout();
        }
    }

    public void testIsSameNode3() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyvalue");
        this.testRootNode.save();
        String srcPath = n.getPath();
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        this.testRootNode.getSession().move(srcPath, destPath);
        IsSameTest.assertTrue((boolean)n.isSame(this.superuser.getItem(destPath)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameNode4() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyvalue");
        this.testRootNode.save();
        String srcPath = n.getPath();
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        this.testRootNode.getSession().move(srcPath, destPath);
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node otherNode = (Node)otherSession.getItem(srcPath);
            IsSameTest.assertTrue((boolean)n.isSame((Item)otherNode));
            IsSameTest.assertTrue((boolean)this.superuser.getItem(destPath).isSame((Item)otherNode));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameNode5() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.addMixin(this.mixReferenceable);
        this.testRootNode.save();
        String srcPath = n.getPath();
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node otherNode = (Node)otherSession.getItem(srcPath);
            this.testRootNode.getSession().getWorkspace().move(srcPath, destPath);
            IsSameTest.assertTrue((boolean)otherNode.isSame((Item)n));
            IsSameTest.assertTrue((boolean)n.isSame((Item)otherNode));
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameNode6() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.addMixin(this.mixReferenceable);
        this.testRootNode.save();
        String srcPath = n.getPath();
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node otherNode = (Node)otherSession.getItem(srcPath);
            this.testRootNode.getSession().getWorkspace().move(srcPath, destPath);
            otherNode.refresh(false);
            try {
                IsSameTest.assertTrue((boolean)n.isSame((Item)otherNode));
            }
            catch (InvalidItemStateException invalidItemStateException) {
                // empty catch block
            }
            try {
                IsSameTest.assertTrue((boolean)otherNode.isSame((Item)n));
            }
            catch (InvalidItemStateException invalidItemStateException) {
                // empty catch block
            }
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsSameNode7() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = n.addNode(this.nodeName2);
        Node n3 = n2.addNode(this.nodeName3);
        this.testRootNode.save();
        n.addMixin(this.mixReferenceable);
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node otherNode3 = (Node)otherSession.getItem(n3.getPath());
            IsSameTest.assertTrue((boolean)otherNode3.isSame((Item)n3));
            Node parent = otherNode3.getParent();
            IsSameTest.assertTrue((boolean)parent.isSame((Item)n2));
            parent = parent.getParent();
            IsSameTest.assertTrue((boolean)parent.isSame((Item)n));
            parent = parent.getParent();
            IsSameTest.assertTrue((boolean)this.testRootNode.isSame((Item)parent));
        }
        finally {
            otherSession.logout();
        }
    }

    public void testSameInstanceIsSame() throws RepositoryException {
        IsSameTest.assertTrue((boolean)this.testRootNode.isSame((Item)this.testRootNode));
        Property p = this.testRootNode.getProperty(this.jcrPrimaryType);
        IsSameTest.assertTrue((boolean)p.isSame((Item)p));
    }

    public void testNewNodeIsSame() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        IsSameTest.assertTrue((boolean)n.isSame((Item)n));
        n.remove();
        Node n2 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        try {
            IsSameTest.assertFalse((boolean)n2.isSame((Item)n));
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            IsSameTest.assertFalse((boolean)n.isSame((Item)n2));
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testNewPropertyIsSame() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyValue");
        IsSameTest.assertTrue((boolean)p.isSame((Item)p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewItemFromDifferentSessions() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyValue");
        Session s2 = this.getHelper().getReadWriteSession();
        try {
            Node trn = (Node)s2.getItem(this.testRootNode.getPath());
            Node n2 = trn.addNode(this.nodeName1, this.testNodeType);
            Property p2 = n2.setProperty(this.propertyName1, "anyValue");
            IsSameTest.assertFalse((boolean)n.isSame((Item)n2));
            IsSameTest.assertFalse((boolean)n2.isSame((Item)n));
            IsSameTest.assertFalse((boolean)p.isSame((Item)p2));
            IsSameTest.assertFalse((boolean)p2.isSame((Item)p));
        }
        finally {
            s2.logout();
        }
    }

    public void testDifferentItemType() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyValue");
        IsSameTest.assertFalse((boolean)p.isSame((Item)n));
        IsSameTest.assertFalse((boolean)n.isSame((Item)p));
    }

    public void testShadowingItems() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyValue");
        this.testRootNode.save();
        this.testRootNode.getSession().move(n.getPath(), n2.getPath() + "/destination");
        Node replaceNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property replaceProp = replaceNode.setProperty(this.propertyName1, "anyValue");
        IsSameTest.assertFalse((boolean)replaceNode.isSame((Item)n));
        IsSameTest.assertFalse((boolean)replaceProp.isSame((Item)p));
    }

    public void testShadowingItems2() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Node n2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyValue");
        this.testRootNode.getSession().move(n.getPath(), n2.getPath() + "/destination");
        Node replaceNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property replaceProp = replaceNode.setProperty(this.propertyName1, "anyValue");
        IsSameTest.assertFalse((boolean)replaceNode.isSame((Item)n));
        IsSameTest.assertFalse((boolean)replaceProp.isSame((Item)p));
    }

    public void testShadowingItems3() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Property p = n.setProperty(this.propertyName1, "anyValue");
        this.testRootNode.save();
        p.remove();
        Property p2 = n.setProperty(this.propertyName1, "anyValue");
        try {
            IsSameTest.assertFalse((boolean)p2.isSame((Item)p));
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }
}

