/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;

public class ItemInfoStore {
    private final Map<ItemId, ItemInfo> infos = new HashMap<ItemId, ItemInfo>();
    private final Map<ItemId, Collection<ItemInfo>> batches = new HashMap<ItemId, Collection<ItemInfo>>();
    private final Map<ItemId, Collection<ChildInfo>> childInfos = new HashMap<ItemId, Collection<ChildInfo>>();

    public ItemInfo getItemInfo(ItemId id) throws ItemNotFoundException {
        ItemInfo itemInfo = this.infos.get(id);
        return itemInfo == null ? (ItemInfo)ItemInfoStore.notFound(id) : itemInfo;
    }

    public Iterator<ItemInfo> getItemInfos() {
        return this.infos.values().iterator();
    }

    public NodeInfo getNodeInfo(NodeId id) throws ItemNotFoundException {
        ItemInfo itemInfo = this.getItemInfo((ItemId)id);
        return itemInfo.denotesNode() ? (NodeInfo)itemInfo : (NodeInfo)ItemInfoStore.notFound((ItemId)id);
    }

    public PropertyInfo getPropertyInfo(PropertyId id) throws ItemNotFoundException {
        ItemInfo itemInfo = this.getItemInfo((ItemId)id);
        return itemInfo.denotesNode() ? (PropertyInfo)ItemInfoStore.notFound((ItemId)id) : (PropertyInfo)itemInfo;
    }

    public Iterator<? extends ItemInfo> getBatch(ItemId id) {
        Iterable batch = this.batches.get(id);
        return batch == null ? Iterators.empty() : batch.iterator();
    }

    public Iterator<ChildInfo> getChildInfos(NodeId id) throws ItemNotFoundException {
        Iterable childs = this.childInfos.get(id);
        return childs == null ? (Iterator)ItemInfoStore.notFound((ItemId)id) : childs.iterator();
    }

    public void addItemInfo(ItemInfo info) {
        this.infos.put(info.getId(), info);
    }

    public void updateBatch(ItemId id, ItemInfo info) {
        if (!this.batches.containsKey(id)) {
            this.batches.put(id, new ArrayList());
        }
        this.batches.get(id).add(info);
    }

    public void updateChilds(ItemId id, ChildInfo info) {
        if (!this.childInfos.containsKey(id)) {
            this.childInfos.put(id, new ArrayList());
        }
        this.childInfos.get(id).add(info);
    }

    public void setChildInfos(NodeId id, Iterator<ChildInfo> infos) {
        this.childInfos.put((ItemId)id, ItemInfoStore.toList(infos));
    }

    private static <T> T notFound(ItemId itemId) throws ItemNotFoundException {
        throw new ItemNotFoundException(itemId.toString());
    }

    private static <T> List<T> toList(Iterator<T> infos) {
        ArrayList<T> list = new ArrayList<T>();
        while (infos.hasNext()) {
            list.add(infos.next());
        }
        return list;
    }
}

