/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class LazyItemIteratorTest
extends AbstractJCRTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSizeGreaterMinusOne() throws RepositoryException {
        PropertyIterator it = this.testRootNode.getProperties();
        LazyItemIteratorTest.assertTrue((it.getSize() > 0L ? 1 : 0) != 0);
        if (this.testRootNode.hasNodes()) {
            it = this.testRootNode.getNodes();
            LazyItemIteratorTest.assertTrue((it.getSize() > 0L ? 1 : 0) != 0);
        }
    }

    public void testSizeOfEmptyIteratorIsZero() throws RepositoryException {
        String nameHint;
        int i = 0;
        String name = nameHint = "noExisting";
        while (this.testRootNode.hasProperty(name)) {
            name = name + i;
            ++i;
        }
        PropertyIterator it = this.testRootNode.getProperties(name);
        LazyItemIteratorTest.assertTrue((it.getSize() == 0L ? 1 : 0) != 0);
        name = nameHint;
        while (this.testRootNode.hasNode(name)) {
            name = name + i;
            ++i;
        }
        it = this.testRootNode.getNodes(name);
        LazyItemIteratorTest.assertTrue((it.getSize() == 0L ? 1 : 0) != 0);
    }

    public void testSizeShrinksIfInvalidItemFound() throws NotExecutableException, RepositoryException {
        NodeIterator it;
        try {
            this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.testRootNode.addNode(this.nodeName2, this.testNodeType);
            Node child = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
            this.testRootNode.save();
            it = this.testRootNode.getNodes();
            child.remove();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        long size = it.getSize();
        long zise = 0L;
        while (it.hasNext()) {
            it.next();
            ++zise;
        }
        LazyItemIteratorTest.assertTrue((size == zise + 1L ? 1 : 0) != 0);
        LazyItemIteratorTest.assertTrue((it.getSize() == zise ? 1 : 0) != 0);
    }
}

