/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.ItemImpl;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixinModificationTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(MixinModificationTest.class);

    private static void assertItemStatus(Item item, int status) throws NotExecutableException {
        if (!(item instanceof ItemImpl)) {
            throw new NotExecutableException("org.apache.jackrabbit.jcr2spi.ItemImpl expected");
        }
        int st = ((ItemImpl)item).getItemState().getStatus();
        MixinModificationTest.assertEquals((String)("Expected status to be " + Status.getName((int)status) + ", was " + Status.getName((int)st)), (int)status, (int)st);
    }

    public void testAddMixin() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(this.nodeName1);
        this.testRootNode.save();
        if (n.isNodeType(this.mixVersionable)) {
            throw new NotExecutableException();
        }
        try {
            n.addMixin(this.mixVersionable);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        MixinModificationTest.assertItemStatus((Item)n, 2);
        MixinModificationTest.assertTrue((boolean)n.hasProperty(this.jcrMixinTypes));
        Property p = n.getProperty(this.jcrMixinTypes);
        n.save();
        MixinModificationTest.assertItemStatus((Item)n, 0);
        MixinModificationTest.assertItemStatus((Item)p, 1);
    }

    public void testAddMixin2() throws RepositoryException, NotExecutableException {
        Node n;
        try {
            n = this.testRootNode.addNode(this.nodeName1);
            n.addMixin(this.mixVersionable);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        MixinModificationTest.assertItemStatus((Item)n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveMixin() throws RepositoryException, NotExecutableException {
        String nPath;
        try {
            Node n = this.testRootNode.addNode(this.nodeName1);
            nPath = n.getPath();
            n.addMixin(this.mixReferenceable);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        Session testSession = this.getHelper().getReadWriteSession();
        try {
            Node n22;
            Node n = (Node)testSession.getItem(nPath);
            String uuid = n.getUUID();
            n.removeMixin(this.mixReferenceable);
            MixinModificationTest.assertFalse((boolean)n.hasProperty(this.jcrMixinTypes));
            n.save();
            try {
                n22 = testSession.getNodeByUUID(uuid);
                MixinModificationTest.fail();
            }
            catch (ItemNotFoundException n22) {
                // empty catch block
            }
            MixinModificationTest.assertItemStatus((Item)n, 1);
            MixinModificationTest.assertFalse((boolean)n.isNodeType(this.mixReferenceable));
            MixinModificationTest.assertTrue((boolean)testSession.itemExists(nPath));
            try {
                n22 = this.superuser.getNodeByUUID(uuid);
                MixinModificationTest.fail();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        finally {
            if (testSession != null) {
                testSession.logout();
            }
        }
    }
}

