/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveCombinedTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(MoveCombinedTest.class);
    private Session testSession;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testSession = this.getHelper().getReadOnlySession();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.testSession != null) {
            this.testSession.logout();
            this.testSession = null;
        }
        super.tearDown();
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testMoveAndAddNode() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        Node n = this.moveNode.addNode(this.nodeName3);
        this.superuser.save();
        MoveCombinedTest.assertTrue((boolean)this.testSession.itemExists(n.getPath()));
    }

    public void testMoveAndAddProperty() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        Property p = this.moveNode.setProperty(this.propertyName1, "someValue");
        this.superuser.save();
        MoveCombinedTest.assertTrue((boolean)this.testSession.itemExists(p.getPath()));
    }

    public void testMoveAndSetPropertyValue() throws RepositoryException {
        Property p = this.moveNode.setProperty(this.propertyName1, "someValue");
        this.moveNode.save();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        p = this.moveNode.setProperty(this.propertyName1, "changedValue");
        this.superuser.save();
        MoveCombinedTest.assertTrue((boolean)this.testSession.itemExists(p.getPath()));
    }

    public void testMoveAndRemove() throws RepositoryException {
        Node n = this.moveNode.addNode(this.nodeName3);
        String nPath = n.getPath();
        this.superuser.save();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        n.remove();
        this.superuser.save();
        MoveCombinedTest.assertFalse((boolean)this.testSession.itemExists(nPath));
        MoveCombinedTest.assertFalse((boolean)this.testSession.itemExists(this.destinationPath + "/" + this.nodeName3));
    }

    public void testMoveAndSetMixin() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.moveNode.addMixin(this.mixVersionable);
        this.superuser.save();
        Node n = (Node)this.testSession.getItem(this.destinationPath);
        MoveCombinedTest.assertTrue((boolean)n.isNodeType(this.mixVersionable));
    }
}

