/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveMultipleTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(MoveMultipleTest.class);
    private String originalPath;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.originalPath = this.moveNode.getPath();
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testMultipleMove() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        String destPath2 = this.srcParentNode.getPath() + "/" + this.nodeName1;
        this.doMove(this.destinationPath, destPath2);
        MoveMultipleTest.assertTrue((boolean)this.moveNode.getParent().isSame((Item)this.srcParentNode));
        MoveMultipleTest.assertEquals((String)this.moveNode.getName(), (String)Text.getName((String)destPath2));
        MoveMultipleTest.assertEquals((String)this.moveNode.getPath(), (String)destPath2);
        MoveMultipleTest.assertFalse((boolean)this.destParentNode.hasNode(Text.getName((String)this.destinationPath)));
        String destPath3 = this.destParentNode.getPath() + "/" + this.nodeName4;
        this.doMove(destPath2, destPath3);
        MoveMultipleTest.assertTrue((boolean)this.moveNode.getParent().isSame((Item)this.destParentNode));
        MoveMultipleTest.assertEquals((String)this.moveNode.getName(), (String)Text.getName((String)destPath3));
        MoveMultipleTest.assertEquals((String)this.moveNode.getPath(), (String)destPath3);
        MoveMultipleTest.assertFalse((boolean)this.srcParentNode.hasNode(Text.getName((String)destPath2)));
        this.testRootNode.save();
        MoveMultipleTest.assertTrue((boolean)this.moveNode.getParent().isSame((Item)this.destParentNode));
        MoveMultipleTest.assertEquals((String)this.moveNode.getName(), (String)Text.getName((String)destPath3));
        MoveMultipleTest.assertEquals((String)this.moveNode.getPath(), (String)destPath3);
        MoveMultipleTest.assertFalse((boolean)this.srcParentNode.hasNode(Text.getName((String)destPath2)));
    }

    public void testRevertingMultipleMove() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        String destPath2 = this.srcParentNode.getPath() + "/" + this.nodeName1;
        this.doMove(this.destinationPath, destPath2);
        String destPath3 = this.destParentNode.getPath() + "/" + this.nodeName4;
        this.doMove(destPath2, destPath3);
        this.superuser.refresh(false);
        MoveMultipleTest.assertEquals((String)this.moveNode.getPath(), (String)this.originalPath);
        MoveMultipleTest.assertTrue((boolean)this.srcParentNode.hasNode(Text.getName((String)this.originalPath)));
        MoveMultipleTest.assertFalse((boolean)this.srcParentNode.hasNode(Text.getName((String)destPath2)));
        MoveMultipleTest.assertFalse((boolean)this.destParentNode.hasNodes());
    }

    public void testMultipleMoveNewNode() throws RepositoryException {
        Node moveNode2 = this.moveNode.addNode(this.nodeName3, this.testNodeType);
        this.doMove(moveNode2.getPath(), this.destinationPath);
        String destPath2 = this.destParentNode.getPath() + "/" + this.nodeName4;
        this.doMove(moveNode2.getPath(), destPath2);
        String destPath3 = this.srcParentNode.getPath() + "/" + this.nodeName4;
        this.doMove(moveNode2.getPath(), destPath3);
        this.doMove(moveNode2.getPath(), this.destinationPath);
        this.testRootNode.save();
        MoveMultipleTest.assertTrue((boolean)moveNode2.getParent().isSame((Item)this.destParentNode));
        MoveMultipleTest.assertEquals((String)moveNode2.getName(), (String)Text.getName((String)this.destinationPath));
        MoveMultipleTest.assertEquals((String)moveNode2.getPath(), (String)this.destinationPath);
        MoveMultipleTest.assertFalse((boolean)moveNode2.hasNodes());
        this.superuser.save();
    }

    public void testMoveDestination() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.doMove(this.destParentNode.getPath(), this.srcParentNode.getPath() + "/" + this.destParentNode.getName());
        this.superuser.save();
        MoveMultipleTest.assertTrue((boolean)this.destParentNode.getParent().isSame((Item)this.srcParentNode));
        MoveMultipleTest.assertTrue((boolean)this.moveNode.getParent().isSame((Item)this.destParentNode));
    }

    public void testMoveParentAndChild() throws RepositoryException {
        Node moveNode2 = this.moveNode.addNode(this.nodeName3, this.testNodeType);
        Property childProperty = moveNode2.setProperty(this.propertyName2, "anyString");
        Node childNode = moveNode2.addNode(this.nodeName4, this.testNodeType);
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.doMove(moveNode2.getPath(), this.srcParentNode.getPath() + "/" + moveNode2.getName());
        MoveMultipleTest.assertFalse((boolean)this.moveNode.hasNode(moveNode2.getName()));
        MoveMultipleTest.assertFalse((boolean)this.moveNode.hasNodes());
        MoveMultipleTest.assertTrue((boolean)this.srcParentNode.getNode(moveNode2.getName()).isSame((Item)moveNode2));
        this.doMove(this.moveNode.getPath(), this.originalPath);
        MoveMultipleTest.assertEquals((String)this.moveNode.getPath(), (String)this.originalPath);
        MoveMultipleTest.assertFalse((boolean)this.destParentNode.hasNode(Text.getName((String)this.destinationPath)));
        MoveMultipleTest.assertFalse((boolean)this.moveNode.hasNode(moveNode2.getName()));
        MoveMultipleTest.assertFalse((boolean)this.moveNode.hasNodes());
        MoveMultipleTest.assertTrue((boolean)this.srcParentNode.getNode(moveNode2.getName()).isSame((Item)moveNode2));
        this.superuser.save();
        MoveMultipleTest.assertFalse((boolean)this.moveNode.hasNodes());
        MoveMultipleTest.assertTrue((boolean)moveNode2.hasNode(childNode.getName()));
        MoveMultipleTest.assertTrue((boolean)moveNode2.hasProperty(childProperty.getName()));
        MoveMultipleTest.assertTrue((boolean)this.srcParentNode.getNode(this.moveNode.getName()).isSame((Item)this.moveNode));
        MoveMultipleTest.assertTrue((boolean)this.srcParentNode.getNode(moveNode2.getName()).isSame((Item)moveNode2));
    }

    public void testRevertingMoveParentAndChild() throws RepositoryException {
        Node moveNode2 = this.moveNode.addNode(this.nodeName3, this.testNodeType);
        this.moveNode.save();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.doMove(moveNode2.getPath(), this.srcParentNode.getPath() + "/" + moveNode2.getName());
        this.doMove(this.moveNode.getPath(), this.originalPath);
        this.testRootNode.refresh(false);
        MoveMultipleTest.assertTrue((boolean)moveNode2.getParent().isSame((Item)this.moveNode));
        MoveMultipleTest.assertTrue((boolean)this.moveNode.getParent().isSame((Item)this.srcParentNode));
        MoveMultipleTest.assertFalse((boolean)this.destParentNode.hasNodes());
        MoveMultipleTest.assertFalse((boolean)this.srcParentNode.hasNode(moveNode2.getName()));
    }

    public void testMoveNewParentAndNewChild() throws RepositoryException {
        Node moveNode2 = this.moveNode.addNode("moveNode2", this.testNodeType);
        Property childProperty = moveNode2.setProperty(this.propertyName2, "anyString");
        Node childNode = moveNode2.addNode("childNode", this.testNodeType);
        this.doMove(moveNode2.getPath(), this.destinationPath);
        this.doMove(childNode.getPath(), this.srcParentNode.getPath() + "/" + childNode.getName());
        this.doMove(moveNode2.getPath(), this.srcParentNode.getPath() + "/" + this.nodeName4);
        this.superuser.save();
        MoveMultipleTest.assertTrue((boolean)moveNode2.getName().equals(this.nodeName4));
        MoveMultipleTest.assertFalse((boolean)moveNode2.hasNodes());
        MoveMultipleTest.assertTrue((boolean)moveNode2.hasProperty(childProperty.getName()));
        MoveMultipleTest.assertTrue((boolean)moveNode2.getParent().isSame((Item)this.srcParentNode));
        MoveMultipleTest.assertTrue((boolean)childNode.getParent().isSame((Item)this.srcParentNode));
    }

    public void testRevertingMoveParentAndNewChild() throws RepositoryException {
        Node moveNode2 = this.moveNode.addNode(this.nodeName3, this.testNodeType);
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.doMove(moveNode2.getPath(), this.srcParentNode.getPath() + "/" + moveNode2.getName());
        this.doMove(this.moveNode.getPath(), this.originalPath);
        this.testRootNode.refresh(false);
        try {
            moveNode2.getParent();
            MoveMultipleTest.fail((String)"Reverting the move of a 'new' node must remove the new node as well.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        MoveMultipleTest.assertTrue((boolean)this.moveNode.getParent().isSame((Item)this.srcParentNode));
        MoveMultipleTest.assertFalse((boolean)this.destParentNode.hasNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAccessChildrenAfterMove() throws RepositoryException {
        Property childProperty = this.moveNode.setProperty(this.propertyName2, "anyString");
        Node childNode = this.moveNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            otherSession.move(this.originalPath, this.destinationPath);
            Node mv = (Node)otherSession.getItem(this.destinationPath);
            this.testRootNode.refresh(false);
            MoveMultipleTest.assertTrue((boolean)childNode.isSame((Item)mv.getNode(this.nodeName2)));
            MoveMultipleTest.assertTrue((boolean)childProperty.isSame((Item)mv.getProperty(this.propertyName2)));
        }
        finally {
            otherSession.logout();
        }
    }
}

