/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTreeTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveNewTreeTest
extends AbstractMoveTreeTest {
    private static Logger log = LoggerFactory.getLogger(MoveNewTreeTest.class);

    @Override
    protected boolean saveBeforeMove() {
        return false;
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testTreeAncestors() throws RepositoryException {
        int degree = this.destParentNode.getDepth();
        Item ancestor = this.childNode.getAncestor(degree);
        MoveNewTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)ancestor.isSame((Item)this.destParentNode));
        ancestor = this.childProperty.getAncestor(degree);
        MoveNewTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)ancestor.isSame((Item)this.destParentNode));
        ancestor = this.grandChildNode.getAncestor(degree);
        MoveNewTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)ancestor.isSame((Item)this.destParentNode));
    }

    public void testTreeEntries() throws RepositoryException {
        Item item = this.superuser.getItem(this.destinationPath + "/" + this.nodeName2);
        MoveNewTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)this.childNode.isSame(item));
        item = this.superuser.getItem(this.destinationPath + "/" + this.propertyName2);
        MoveNewTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)this.childProperty.isSame(item));
        item = this.superuser.getItem(this.destinationPath + "/" + this.nodeName2 + "/" + this.nodeName3);
        MoveNewTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)this.grandChildNode.isSame(item));
    }

    public void testOldPath() throws RepositoryException {
        try {
            this.superuser.getItem(this.srcPath + "/" + this.nodeName2 + "/" + this.nodeName3);
            MoveNewTreeTest.fail((String)"Moving a node must move all child items as well.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRevertRemovedFromSrc() throws RepositoryException {
        this.superuser.refresh(false);
        MoveNewTreeTest.assertFalse((String)"Reverting move of a new node must remove the node from both positions.", (boolean)this.superuser.itemExists(this.srcPath));
    }

    public void testRevertRemovedFromDestination() throws RepositoryException {
        this.superuser.refresh(false);
        MoveNewTreeTest.assertFalse((String)"Reverting move of a new node must remove the node from both positions.", (boolean)this.superuser.itemExists(this.destinationPath));
    }

    public void testRevertInvalidatedMovedTree() throws RepositoryException {
        this.superuser.refresh(false);
        try {
            this.childNode.getAncestor(0);
            MoveNewTreeTest.fail((String)"Reverting move of a new node must remove the tree completely");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            this.childProperty.getAncestor(0);
            MoveNewTreeTest.fail((String)"Reverting move of a new node must remove the tree completely");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        try {
            this.grandChildNode.getAncestor(0);
            MoveNewTreeTest.fail((String)"Reverting move of a new node must remove the tree completely");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testRefreshMovedTree() throws RepositoryException {
        this.testRootNode.refresh(true);
        String msg = "Refresh must not revert a moved tree.";
        MoveNewTreeTest.assertFalse((String)msg, (boolean)this.superuser.itemExists(this.srcPath + "/" + this.nodeName2 + "/" + this.nodeName3));
        int degree = this.destParentNode.getDepth();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(this.childNode);
        l.add(this.childProperty);
        l.add(this.grandChildNode);
        for (Item item : l) {
            MoveNewTreeTest.assertTrue((String)msg, (boolean)item.isNew());
            MoveNewTreeTest.assertTrue((String)msg, (boolean)this.childNode.getAncestor(degree).isSame((Item)this.destParentNode));
        }
    }
}

