/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveReferenceableTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(MoveReferenceableTest.class);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (!this.moveNode.canAddMixin(this.mixReferenceable)) {
            throw new NotExecutableException("Cannot add mix:referencable to node to be moved.");
        }
        this.moveNode.addMixin(this.mixReferenceable);
        this.moveNode.save();
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testMovedReferenceable() throws RepositoryException, NotExecutableException {
        String uuid = this.moveNode.getUUID();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        MoveReferenceableTest.assertEquals((String)"After successful moving a referenceable node node, the uuid must not have changed.", (String)uuid, (String)this.moveNode.getUUID());
    }

    public void testMovedReferenceable2() throws RepositoryException, NotExecutableException {
        String uuid = this.moveNode.getUUID();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.superuser.save();
        MoveReferenceableTest.assertEquals((String)"After successful moving a referenceable node node, the uuid must not have changed.", (String)uuid, (String)this.moveNode.getUUID());
    }

    public void testAccessMovedReferenceableByUUID() throws RepositoryException, NotExecutableException {
        String uuid = this.moveNode.getUUID();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        Node n = this.superuser.getNodeByUUID(uuid);
        MoveReferenceableTest.assertTrue((String)"After successful moving a referenceable node node, accessing the node by uuid must return the same node.", (boolean)n.isSame((Item)this.moveNode));
    }

    public void testAccessMovedReferenceableByUUID2() throws RepositoryException, NotExecutableException {
        String uuid = this.moveNode.getUUID();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.superuser.save();
        Node n = this.superuser.getNodeByUUID(uuid);
        MoveReferenceableTest.assertTrue((String)"After successful moving a referenceable node node, accessing the node by uuid must return the same node.", (boolean)n.isSame((Item)this.moveNode));
    }

    public void testMoveTwice() throws RepositoryException {
        this.moveNode.addMixin(this.mixVersionable);
        this.superuser.save();
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.superuser.save();
        String destinationPath2 = this.destParentNode.getPath() + "/" + this.nodeName3;
        this.doMove(this.destinationPath, destinationPath2);
        this.superuser.save();
    }
}

