/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveSNSTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(MoveSNSTest.class);
    private Node sourceSibling;
    private Node destSibling;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.destParentNode.hasNode(this.nodeName2)) {
            MoveSNSTest.fail((String)("Setup: Move destination already contains a child node with name " + this.nodeName2));
        }
        if (!this.moveNode.getDefinition().allowsSameNameSiblings()) {
            MoveSNSTest.fail((String)"Setup: Unable to create SNS-node for MoveSNSTest.");
        }
        this.sourceSibling = this.srcParentNode.addNode(this.nodeName2, this.testNodeType);
        this.destSibling = this.destParentNode.addNode(this.nodeName2, this.testNodeType);
        if (!this.destSibling.getDefinition().allowsSameNameSiblings()) {
            MoveSNSTest.fail((String)"Setup: Unable to create SNS-node at move destination.");
        }
        this.testRootNode.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.sourceSibling = null;
        this.destSibling = null;
        super.tearDown();
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testMovedNodeGetPath() throws RepositoryException, NotExecutableException {
        int index = this.destSibling.getIndex() + 1;
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        MoveSNSTest.assertEquals((String)"After successful move the moved node must return the destination path.", (String)(this.destinationPath + "[" + index + "]"), (String)this.moveNode.getPath());
    }

    public void testMovedNodeGetPath2() throws RepositoryException, NotExecutableException {
        int index = this.destSibling.getIndex() + 1;
        this.doMove(this.moveNode.getPath(), this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        MoveSNSTest.assertEquals((String)"After successful move the moved node must return the destination path.", (String)(this.destinationPath + "[" + index + "]"), (String)this.moveNode.getPath());
    }

    public void testAccessMovedNodeByOldPath() throws RepositoryException, NotExecutableException {
        String oldPath = this.moveNode.getPath();
        this.doMove(oldPath, this.destinationPath);
        try {
            Item item = this.superuser.getItem(oldPath);
            MoveSNSTest.assertTrue((String)"A moved SNS node must be 'replaced' but is successor sibling.", (boolean)item.isSame((Item)this.sourceSibling));
        }
        catch (PathNotFoundException e) {
            MoveSNSTest.fail((String)"A moved SNS node must be 'replaced' but is successor sibling.");
        }
    }

    public void testAccessMovedNodeByOldPath2() throws RepositoryException, NotExecutableException {
        String oldPath = this.moveNode.getPath();
        this.doMove(oldPath, this.destinationPath);
        this.superuser.save();
        try {
            Item item = this.superuser.getItem(oldPath);
            MoveSNSTest.assertTrue((String)"A moved SNS node must be 'replaced' but is successor sibling.", (boolean)item.isSame((Item)this.sourceSibling));
        }
        catch (PathNotFoundException e) {
            MoveSNSTest.fail((String)"A moved SNS node must be 'replaced' but is successor sibling.");
        }
    }

    public void testMovedNodeIsSame() throws RepositoryException, NotExecutableException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        int cnt = 0;
        NodeIterator it = this.destParentNode.getNodes(this.nodeName2);
        while (it.hasNext()) {
            Node n = it.nextNode();
            if (cnt == 0) {
                MoveSNSTest.assertTrue((String)"Moved node must be appended to list of SNSs.", (boolean)this.destSibling.isSame((Item)n));
            } else {
                MoveSNSTest.assertTrue((String)"Moved node must be appended to list of SNSs.", (boolean)this.moveNode.isSame((Item)n));
            }
            ++cnt;
        }
    }

    public void testMovedNodeIsSame2() throws RepositoryException, NotExecutableException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.superuser.save();
        int cnt = 0;
        NodeIterator it = this.destParentNode.getNodes(this.nodeName2);
        while (it.hasNext()) {
            Node n = it.nextNode();
            if (cnt == 0) {
                MoveSNSTest.assertTrue((String)"Moved node must be appended to list of SNSs.", (boolean)this.destSibling.isSame((Item)n));
            } else {
                MoveSNSTest.assertTrue((String)"Moved node must be appended to list of SNSs.", (boolean)this.moveNode.isSame((Item)n));
            }
            ++cnt;
        }
    }
}

