/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(MoveTest.class);

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testMoveRoot() throws RepositoryException {
        Node root = this.superuser.getRootNode();
        try {
            this.doMove(root.getPath(), this.destinationPath);
            MoveTest.fail((String)"Moving the root node must fail with RepositoryException.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testMoveBelowDescendant() throws RepositoryException {
        try {
            this.doMove(this.srcParentNode.getPath(), this.moveNode.getPath() + "/" + this.nodeName2);
            MoveTest.fail((String)"Moving the ancestor node below descendant must fail with RepositoryException.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testMoveDestinationWithIndex() throws RepositoryException {
        try {
            this.doMove(this.moveNode.getPath(), this.destinationPath + "[1]");
            MoveTest.fail((String)"Moving to destination with index must fail with RepositoryException.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testMovedNodeGetPath() throws RepositoryException, NotExecutableException {
        String oldPath = this.moveNode.getPath();
        if (this.destParentNode.hasNode(this.nodeName2)) {
            throw new NotExecutableException("Move destination already contains a child node with name " + this.nodeName2);
        }
        this.doMove(oldPath, this.destinationPath);
        MoveTest.assertEquals((String)"After successful move the moved node must return the destination path.", (String)this.destinationPath, (String)this.moveNode.getPath());
    }

    public void testMovedNodeGetPath2() throws RepositoryException, NotExecutableException {
        String oldPath = this.moveNode.getPath();
        if (this.destParentNode.hasNode(this.nodeName2)) {
            throw new NotExecutableException("Move destination already contains a child node with name " + this.nodeName2);
        }
        this.doMove(oldPath, this.destParentNode.getPath() + "/" + this.nodeName2);
        this.superuser.save();
        MoveTest.assertEquals((String)"After successful move the moved node must return the destination path.", (String)this.destinationPath, (String)this.moveNode.getPath());
    }

    public void testAccessMovedNodeByOldPath() throws RepositoryException, NotExecutableException {
        NodeIterator it = this.srcParentNode.getNodes(this.moveNode.getName());
        int cnt = 0;
        while (it.hasNext()) {
            it.nextNode();
            ++cnt;
        }
        if (cnt > 1) {
            throw new NotExecutableException("Move source parent has multiple child nodes with name " + this.moveNode.getName());
        }
        String oldPath = this.moveNode.getPath();
        this.doMove(oldPath, this.destinationPath);
        try {
            this.superuser.getItem(oldPath);
            MoveTest.fail((String)"A moved node must not be accessible by its old path any more.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testAccessMovedNodeByOldPath2() throws RepositoryException, NotExecutableException {
        NodeIterator it = this.srcParentNode.getNodes(this.moveNode.getName());
        int cnt = 0;
        while (it.hasNext()) {
            it.nextNode();
            ++cnt;
        }
        if (cnt > 1) {
            throw new NotExecutableException("Move source parent has multiple child nodes with name " + this.moveNode.getName());
        }
        String oldPath = this.moveNode.getPath();
        this.doMove(oldPath, this.destinationPath);
        this.superuser.save();
        try {
            this.superuser.getItem(oldPath);
            MoveTest.fail((String)"A moved node must not be accessible by its old path any more.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testMovedNodeIsSame() throws RepositoryException, NotExecutableException {
        if (this.destParentNode.hasNode(this.nodeName2)) {
            throw new NotExecutableException(this.destParentNode + " already has child node " + ". Test cannot be preformed if SNS is present.");
        }
        String oldPath = this.moveNode.getPath();
        String newPath = this.destParentNode.getPath() + "/" + this.nodeName2;
        this.doMove(oldPath, this.destinationPath);
        Item movedItem = this.superuser.getItem(newPath);
        MoveTest.assertTrue((String)"Moved Node must be the same after the move.", (boolean)movedItem.isSame((Item)this.moveNode));
    }

    public void testMovedNodeIsSame2() throws RepositoryException, NotExecutableException {
        if (this.destParentNode.hasNode(this.nodeName2)) {
            throw new NotExecutableException(this.destParentNode + " already has child node " + ". Test cannot be preformed if SNS is present.");
        }
        String oldPath = this.moveNode.getPath();
        this.doMove(oldPath, this.destinationPath);
        this.superuser.save();
        Item movedItem = this.superuser.getItem(this.destinationPath);
        MoveTest.assertTrue((String)"Moved Node must be the same after the move.", (boolean)movedItem.isSame((Item)this.moveNode));
    }

    public void testMovedNodeParent() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        MoveTest.assertTrue((String)"Parent of moved node must be the destination parent node.", (boolean)this.moveNode.getParent().isSame((Item)this.destParentNode));
    }

    public void testMovedNodeParent2() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.destinationPath);
        this.superuser.save();
        MoveTest.assertTrue((String)"Parent of moved node must be the destination parent node.", (boolean)this.moveNode.getParent().isSame((Item)this.destParentNode));
    }

    public void testMovePropertyExists() throws RepositoryException, NotExecutableException {
        Property destProperty;
        try {
            destProperty = this.destParentNode.setProperty(this.nodeName2, "anyString");
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Cannot create property with name '" + this.nodeName2 + "' and value 'anyString' at move destination.");
        }
        if ("1.0".equals(this.getHelper().getRepository().getDescriptor("jcr.specification.version"))) {
            try {
                this.doMove(this.moveNode.getPath(), destProperty.getPath());
                MoveTest.fail((String)"Moving a node to a location where a property exists must throw ItemExistsException");
            }
            catch (ItemExistsException itemExistsException) {}
        } else {
            this.doMove(this.moveNode.getPath(), destProperty.getPath());
        }
    }

    public void testMoveReferenceableNode() throws RepositoryException {
        this.moveNode.addMixin("mix:referenceable");
        this.moveNode.getSession().save();
        this.superuser.move(this.moveNode.getPath(), this.destParentNode.getPath() + "/" + this.moveNode.getName());
        this.superuser.save();
        this.destParentNode.remove();
        this.destParentNode.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFile() throws RepositoryException, NotExecutableException {
        String filePath;
        String parentPath;
        try {
            Node parent = this.testRootNode.addNode("parent");
            Node n = JcrUtils.putFile((Node)parent, (String)"file", (String)"text/plain", (InputStream)new ByteArrayInputStream("data".getBytes()));
            parentPath = parent.getPath();
            filePath = n.getPath();
            this.superuser.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        Session s = this.getHelper().getSuperuserSession();
        try {
            Node n1 = s.getNode(filePath);
            Node n2 = n1.getNode("jcr:content");
            n2.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("data2".getBytes()));
            n2.save();
            String destPath = parentPath + "1";
            if (this.isSessionMove()) {
                s.move(parentPath, destPath);
                s.save();
            } else {
                s.getWorkspace().move(parentPath, destPath);
            }
            Node n3 = s.getNode(destPath + "/file");
            Node n4 = n3.getNode("jcr:content");
            n4.refresh(false);
            Node node = n3.getNode("jcr:content");
        }
        finally {
            s.logout();
        }
    }
}

