/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.util.Text;

public class MoveToNewTest
extends AbstractJCRTest {
    protected Node srcParentNode;
    protected Node destParentNode;
    protected Node moveNode;
    protected String destinationPath;

    protected void setUp() throws Exception {
        super.setUp();
        this.srcParentNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.moveNode = this.srcParentNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        this.destParentNode = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.destinationPath = this.destParentNode.getPath() + "/" + this.nodeName2;
    }

    protected void tearDown() throws Exception {
        this.srcParentNode = null;
        this.destParentNode = null;
        this.moveNode = null;
        super.tearDown();
    }

    public void testMove() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.testRootNode.getSession().move(srcPath, this.destinationPath);
        MoveToNewTest.assertTrue((boolean)this.destParentNode.isNew());
        MoveToNewTest.assertTrue((boolean)this.moveNode.isModified());
        MoveToNewTest.assertTrue((boolean)this.testRootNode.getSession().itemExists(this.destinationPath));
        MoveToNewTest.assertFalse((boolean)this.testRootNode.getSession().itemExists(srcPath));
    }

    public void testMoveSaved() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.testRootNode.getSession().move(srcPath, this.destinationPath);
        this.testRootNode.save();
        MoveToNewTest.assertFalse((boolean)this.destParentNode.isNew());
        MoveToNewTest.assertFalse((boolean)this.srcParentNode.isModified());
        MoveToNewTest.assertFalse((boolean)this.moveNode.isModified());
        MoveToNewTest.assertTrue((boolean)this.testRootNode.getSession().itemExists(this.destinationPath));
        MoveToNewTest.assertFalse((boolean)this.testRootNode.getSession().itemExists(srcPath));
    }

    public void testRevertMovedNode() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.testRootNode.getSession().move(srcPath, this.destinationPath);
        try {
            this.destParentNode.refresh(false);
            MoveToNewTest.fail((String)"Incomplete 'changelog'");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testRemoveDestParent() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.testRootNode.getSession().move(srcPath, this.destinationPath);
        this.destParentNode.remove();
        MoveToNewTest.assertFalse((boolean)this.destParentNode.isNew());
        MoveToNewTest.assertFalse((boolean)this.destParentNode.isModified());
        MoveToNewTest.assertFalse((boolean)this.moveNode.isModified());
        MoveToNewTest.assertTrue((boolean)this.srcParentNode.isModified());
        MoveToNewTest.assertFalse((boolean)this.testRootNode.getSession().itemExists(srcPath));
    }

    public void testRevertRemoveDestParent() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.testRootNode.getSession().move(srcPath, this.destinationPath);
        this.destParentNode.remove();
        this.testRootNode.refresh(false);
        MoveToNewTest.assertFalse((boolean)this.destParentNode.isModified());
        MoveToNewTest.assertFalse((boolean)this.destParentNode.isNew());
        try {
            this.destParentNode.hasNode(this.nodeName2);
            MoveToNewTest.fail((String)"The new destParent must have been removed.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        MoveToNewTest.assertTrue((boolean)this.srcParentNode.hasNode(this.nodeName2));
        MoveToNewTest.assertFalse((boolean)this.srcParentNode.isModified());
        MoveToNewTest.assertFalse((boolean)this.testRootNode.getSession().itemExists(this.destinationPath));
        MoveToNewTest.assertTrue((boolean)this.testRootNode.getSession().itemExists(srcPath));
    }

    public void testMoveTwice() throws RepositoryException {
        Session s = this.testRootNode.getSession();
        String srcPath = this.moveNode.getPath();
        s.move(srcPath, this.destinationPath);
        this.srcParentNode.remove();
        Node newParent = this.testRootNode.addNode(this.nodeName1);
        s.move(this.destinationPath, srcPath);
        MoveToNewTest.assertTrue((boolean)newParent.isNew());
        MoveToNewTest.assertTrue((boolean)newParent.hasNode(this.nodeName2));
        MoveToNewTest.assertTrue((boolean)this.destParentNode.isNew());
        MoveToNewTest.assertFalse((boolean)this.destParentNode.hasNode(this.nodeName2));
        this.destParentNode.remove();
        MoveToNewTest.assertTrue((boolean)newParent.isNew());
        MoveToNewTest.assertTrue((boolean)newParent.hasNode(this.nodeName2));
        MoveToNewTest.assertTrue((boolean)this.moveNode.isModified());
        this.testRootNode.save();
        MoveToNewTest.assertFalse((boolean)s.itemExists(Text.getRelativeParent((String)this.destinationPath, (int)1)));
        MoveToNewTest.assertTrue((boolean)s.itemExists(srcPath));
        MoveToNewTest.assertFalse((this.moveNode.isModified() || newParent.isNew() || this.srcParentNode.isModified() ? 1 : 0) != 0);
        try {
            this.srcParentNode.getNode(this.nodeName2);
            MoveToNewTest.fail((String)"src parent must be removed");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        MoveToNewTest.assertTrue((boolean)this.moveNode.isSame((Item)newParent.getNode(this.nodeName2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveTwiceWithSecondSession() throws RepositoryException {
        Session s = this.testRootNode.getSession();
        String srcPath = this.moveNode.getPath();
        s.move(srcPath, this.destinationPath);
        this.srcParentNode.remove();
        Node newParent = this.testRootNode.addNode(this.nodeName1);
        newParent.setProperty(this.propertyName1, "marker");
        s.move(this.destinationPath, srcPath);
        this.destParentNode.remove();
        this.testRootNode.save();
        Session readOnly = this.getHelper().getReadOnlySession();
        try {
            Node trn = (Node)readOnly.getItem(this.testRootNode.getPath());
            NodeIterator it = trn.getNodes(this.nodeName1);
            String msg = "testRootNode must have a single child node with name " + this.nodeName1;
            if (it.hasNext()) {
                Node parent = it.nextNode();
                MoveToNewTest.assertTrue((boolean)parent.hasProperty(this.propertyName1));
                MoveToNewTest.assertEquals((String)"The 'newParent' must have the marker property", (String)"marker", (String)parent.getProperty(this.propertyName1).getString());
                MoveToNewTest.assertTrue((String)"moveNode must be present below the 'newParent'.", (boolean)parent.hasNode(Text.getName((String)srcPath)));
                MoveToNewTest.assertFalse((String)msg, (boolean)it.hasNext());
            } else {
                MoveToNewTest.fail((String)msg);
            }
        }
        finally {
            readOnly.logout();
        }
    }
}

