/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTreeTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTreeTest
extends AbstractMoveTreeTest {
    private static Logger log = LoggerFactory.getLogger(MoveTreeTest.class);

    @Override
    protected boolean saveBeforeMove() {
        return true;
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testTreeAncestors() throws RepositoryException {
        int degree = this.destParentNode.getDepth();
        Item ancestor = this.childNode.getAncestor(degree);
        MoveTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)ancestor.isSame((Item)this.destParentNode));
        ancestor = this.childProperty.getAncestor(degree);
        MoveTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)ancestor.isSame((Item)this.destParentNode));
        ancestor = this.grandChildNode.getAncestor(degree);
        MoveTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)ancestor.isSame((Item)this.destParentNode));
    }

    public void testTreeEntries() throws RepositoryException {
        Item item = this.superuser.getItem(this.destinationPath + "/" + this.nodeName2);
        MoveTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)this.childNode.isSame(item));
        item = this.superuser.getItem(this.destinationPath + "/" + this.propertyName2);
        MoveTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)this.childProperty.isSame(item));
        item = this.superuser.getItem(this.destinationPath + "/" + this.nodeName2 + "/" + this.nodeName3);
        MoveTreeTest.assertTrue((String)"Moving a node must move all child items as well.", (boolean)this.grandChildNode.isSame(item));
    }

    public void testOldPath() throws RepositoryException {
        try {
            this.superuser.getItem(this.srcPath + "/" + this.nodeName2);
            MoveTreeTest.fail((String)"Moving a node must move all child items as well.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testOldPropertyPath() throws RepositoryException {
        try {
            this.superuser.getItem(this.srcPath + "/" + this.propertyName2);
            MoveTreeTest.fail((String)"Moving a node must move all child items as well.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testOldChildPath() throws RepositoryException {
        for (int i = 0; i < this.childPaths.size(); ++i) {
            String path = ((String)this.childPaths.get(i)).toString();
            MoveTreeTest.assertFalse((boolean)this.superuser.itemExists(path));
            try {
                this.superuser.getItem(path);
                MoveTreeTest.fail((String)"Moving a node must move all child items as well.");
                continue;
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    public void testOldChildPropertyPath() throws RepositoryException {
        for (int i = 0; i < this.childPaths.size(); ++i) {
            String propPath = ((String)this.childPaths.get(i)).toString() + "/" + this.jcrPrimaryType;
            MoveTreeTest.assertFalse((boolean)this.superuser.itemExists(propPath));
            try {
                this.superuser.getItem(propPath);
                MoveTreeTest.fail((String)"Moving a node must move all child items as well.");
                continue;
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
        }
    }

    public void testAncestorAfterRevert() throws RepositoryException {
        this.superuser.refresh(false);
        Item ancestor = this.grandChildNode.getAncestor(this.srcParentNode.getDepth());
        MoveTreeTest.assertTrue((String)"Reverting a move-operation must move the tree back.", (boolean)ancestor.isSame((Item)this.srcParentNode));
    }

    public void testDestinationAfterRevert() throws RepositoryException {
        this.superuser.refresh(false);
        try {
            this.superuser.getItem(this.destinationPath + "/" + this.propertyName2);
            MoveTreeTest.fail((String)"Reverting a move-operation must move the tree back.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

