/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiValuedPropertyTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(MultiValuedPropertyTest.class);

    public void testGetStreamFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getStream();
            MultiValuedPropertyTest.fail((String)"Property.getStream() must fail with ValueFormatException for any multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetStringFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getString();
            MultiValuedPropertyTest.fail((String)"Property.getString() must fail with ValueFormatException for any multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDateFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getDate();
            MultiValuedPropertyTest.fail((String)"Property.getDate() must fail with ValueFormatException for any multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetDoubleFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getDouble();
            MultiValuedPropertyTest.fail((String)"Property.getDouble() must fail with ValueFormatException for any multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLongFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getLong();
            MultiValuedPropertyTest.fail((String)"Property.getLong() must fail with ValueFormatException for any multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetBooleanFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getBoolean();
            MultiValuedPropertyTest.fail((String)"Property.getLong() must fail with ValueFormatException for any multivalued property.");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }

    public void testGetLengthFromMultivalued() throws RepositoryException, NotExecutableException {
        Property prop = PropertyUtil.searchMultivalProp((Node)this.testRootNode);
        if (prop == null) {
            throw new NotExecutableException("No multivalued property found.");
        }
        try {
            prop.getLength();
            MultiValuedPropertyTest.fail((String)"Property.getLength() called on a multivalue property must fail (ValueFormatException).");
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
    }
}

