/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeOrderTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(NodeOrderTest.class);
    private Node[] children;

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.testRootNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new NotExecutableException("Test node does not have orderable children.");
        }
        this.children = new Node[4];
        this.children[0] = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.children[1] = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.children[2] = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.children[3] = this.testRootNode.addNode(this.nodeName4, this.testNodeType);
        this.testRootNode.save();
    }

    protected void tearDown() throws Exception {
        this.children = null;
        super.tearDown();
    }

    private static void checkOrder(NodeIterator it, Node[] children) throws RepositoryException {
        int i = 0;
        while (it.hasNext()) {
            if (i >= children.length) {
                NodeOrderTest.fail((String)"Node.getNodes() return more child nodes, that have been created.");
            }
            Node n = it.nextNode();
            NodeOrderTest.assertTrue((String)"Wrong order of child nodes returned by Node.getNodes().", (boolean)n.isSame((Item)children[i]));
            ++i;
        }
        if (i != children.length) {
            NodeOrderTest.fail((String)"Node.getNodes() did not return all child nodes.");
        }
    }

    public void testOrder() throws RepositoryException {
        NodeIterator it = this.testRootNode.getNodes();
        NodeOrderTest.checkOrder(it, this.children);
        it = this.testRootNode.getNodes();
        NodeOrderTest.checkOrder(it, this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrder2() throws RepositoryException {
        Session another = this.getHelper().getReadOnlySession();
        try {
            NodeIterator it = ((Node)another.getItem(this.testRootNode.getPath())).getNodes();
            NodeOrderTest.checkOrder(it, this.children);
        }
        finally {
            another.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderAfterIndividualAccess() throws RepositoryException {
        Session another = this.getHelper().getReadOnlySession();
        try {
            Node n2 = (Node)another.getItem(this.children[2].getPath());
            Node n0 = (Node)another.getItem(this.children[0].getPath());
            NodeIterator it = ((Node)another.getItem(this.testRootNode.getPath())).getNodes();
            NodeOrderTest.checkOrder(it, this.children);
        }
        finally {
            another.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderAfterIndividualAccess2() throws RepositoryException {
        Session another = this.getHelper().getReadOnlySession();
        try {
            Node n2 = (Node)another.getItem(this.children[3].getPath());
            Node n3 = (Node)another.getItem(this.children[1].getPath());
            NodeIterator it = ((Node)another.getItem(this.testRootNode.getPath())).getNodes();
            NodeOrderTest.checkOrder(it, this.children);
        }
        finally {
            another.logout();
        }
    }
}

