/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLengthTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(PropertyLengthTest.class);

    private static long getValueLength(Value val) throws RepositoryException {
        long valLength = val.getType() == 2 ? PropertyUtil.countBytes((Value)val) : (long)val.getString().length();
        return valLength;
    }

    private Property getProperty(int propertyType) throws RepositoryException, NotExecutableException {
        Property p = PropertyUtil.searchProp((Session)this.testRootNode.getSession(), (Node)this.testRootNode, (int)propertyType, null);
        if (p == null) {
            try {
                Value val;
                ValueFactory factory = this.testRootNode.getSession().getValueFactory();
                switch (propertyType) {
                    case 2: {
                        val = factory.createValue("binaryValue", 2);
                        break;
                    }
                    case 6: {
                        val = factory.createValue(true);
                        break;
                    }
                    case 5: {
                        val = factory.createValue(Calendar.getInstance());
                        break;
                    }
                    case 4: {
                        val = factory.createValue(new Double(134.0).doubleValue());
                        break;
                    }
                    case 3: {
                        val = factory.createValue(new Long(134L).longValue());
                        break;
                    }
                    case 7: {
                        val = factory.createValue(this.ntBase, 7);
                        break;
                    }
                    case 8: {
                        val = factory.createValue(this.testRootNode.getPath(), 8);
                        break;
                    }
                    case 9: {
                        Node refNode = this.testRootNode.addNode(this.nodeName1);
                        if (refNode.canAddMixin(this.mixReferenceable)) {
                            this.testRootNode.addMixin(this.mixReferenceable);
                        }
                        this.testRootNode.save();
                        val = factory.createValue(refNode);
                        break;
                    }
                    case 1: {
                        val = factory.createValue("StringValue");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid property value type" + propertyType);
                    }
                }
                p = this.testRootNode.setProperty(this.propertyName1, val);
            }
            catch (RepositoryException e) {
                log.error("Unable to create Property of type " + propertyType);
                throw new NotExecutableException();
            }
        }
        return p;
    }

    private static void checkLength(Property p) throws RepositoryException {
        if (p.isMultiple()) {
            Value[] vals = p.getValues();
            long[] lengths = p.getLengths();
            for (int i = 0; i < lengths.length; ++i) {
                PropertyLengthTest.assertTrue((String)"Wrong property length", (lengths[i] == PropertyLengthTest.getValueLength(vals[i]) ? 1 : 0) != 0);
            }
        } else {
            PropertyLengthTest.assertTrue((String)"Wrong property length", (p.getLength() == PropertyLengthTest.getValueLength(p.getValue()) ? 1 : 0) != 0);
        }
    }

    public void testLengthOfBinary() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(2);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfBoolean() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(6);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfDate() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(5);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfDouble() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(4);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfLong() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(3);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfName() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(7);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfPath() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(8);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfReference() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(9);
        PropertyLengthTest.checkLength(p);
    }

    public void testLengthOfString() throws RepositoryException, NotExecutableException {
        Property p = this.getProperty(1);
        PropertyLengthTest.checkLength(p);
    }
}

