/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshFalseTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(RefreshFalseTest.class);
    private Value testValue;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.testRootNode.hasProperty(this.propertyName1)) {
            this.testRootNode.getProperty(this.propertyName1).remove();
            this.testRootNode.save();
        }
        this.testValue = this.testRootNode.getSession().getValueFactory().createValue("anyString");
        if (!this.testRootNode.getPrimaryNodeType().canSetProperty(this.propertyName1, this.testValue)) {
            throw new NotExecutableException("");
        }
    }

    protected void tearDown() throws Exception {
        this.testValue = null;
        super.tearDown();
    }

    public void testNewProperty() throws RepositoryException, LockException, ConstraintViolationException, VersionException {
        Property p = this.testRootNode.setProperty(this.propertyName1, this.testValue);
        this.testRootNode.refresh(false);
        try {
            p.getString();
            RefreshFalseTest.fail((String)"Refresh 'false' must invalidate a new child property");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        RefreshFalseTest.assertFalse((String)"Refresh 'false' must remove a new child property", (boolean)this.testRootNode.hasProperty(this.propertyName1));
    }

    public void testRemovedNewProperty() throws RepositoryException, LockException, ConstraintViolationException, VersionException {
        Property p = this.testRootNode.setProperty(this.propertyName1, this.testValue);
        p.remove();
        this.testRootNode.refresh(false);
        try {
            p.getString();
            RefreshFalseTest.fail((String)"Refresh 'false' must not bring a removed new child property back to life.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        RefreshFalseTest.assertFalse((String)"Refresh 'false' must not bring a removed new child property back to life.", (boolean)this.testRootNode.hasProperty(this.propertyName1));
    }

    public void testRemovedProperty() throws RepositoryException, LockException, ConstraintViolationException, VersionException {
        Property p = this.testRootNode.setProperty(this.propertyName1, this.testValue);
        this.testRootNode.save();
        p.remove();
        this.testRootNode.refresh(false);
        p.getString();
        this.testRootNode.getProperty(this.propertyName1);
    }

    public void testShadowingProperty() throws RepositoryException, LockException, ConstraintViolationException, VersionException {
        Property p = this.testRootNode.setProperty(this.propertyName1, this.testValue);
        this.testRootNode.save();
        p.remove();
        Property pNew = this.testRootNode.setProperty(this.propertyName1, "SomeOtherTestValue");
        this.testRootNode.refresh(false);
        try {
            pNew.getString();
            RefreshFalseTest.fail((String)"Refresh 'false' must remove a new (shadowing) property and bring 'removed' persistent property back to life.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        p.getString();
        Property pAgain = this.testRootNode.getProperty(this.propertyName1);
        RefreshFalseTest.assertTrue((String)"Refresh 'false' must remove a new property and bring 'removed' persistent property back to life.", (boolean)p.isSame((Item)pAgain));
    }
}

