/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshMovedTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(RefreshMovedTest.class);
    protected Node moveNode;
    protected String srcPath;
    protected String destinationPath;

    protected void setUp() throws Exception {
        super.setUp();
        Node srcParentNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.moveNode = srcParentNode.addNode(this.nodeName2, this.testNodeType);
        Node destParentNode = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        this.srcPath = this.moveNode.getPath();
        this.destinationPath = destParentNode.getPath() + "/" + this.nodeName2;
    }

    protected void tearDown() throws Exception {
        this.moveNode = null;
        super.tearDown();
    }

    public void testRefreshTrue() throws RepositoryException {
        this.testRootNode.getSession().move(this.srcPath, this.destinationPath);
        this.testRootNode.getSession().refresh(true);
        RefreshMovedTest.assertTrue((String)"Refresh with pending move operation must not remove the node at destination path.", (boolean)this.testRootNode.getSession().itemExists(this.destinationPath));
        RefreshMovedTest.assertFalse((String)"Refresh with pending move operation must not re-add the node at its original position.", (boolean)this.testRootNode.getSession().itemExists(this.srcPath));
        RefreshMovedTest.assertFalse((String)"Refresh with pending move operation must not re-add the node at its original position.", (boolean)this.srcPath.equals(this.moveNode.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshOtherSession() throws RepositoryException {
        Session readSession = this.getHelper().getReadOnlySession();
        try {
            Node anotherNode = (Node)readSession.getItem(this.srcPath);
            this.testRootNode.getSession().getWorkspace().move(this.srcPath, this.destinationPath);
            readSession.refresh(false);
            try {
                String p = anotherNode.getPath();
                RefreshMovedTest.assertTrue((String)"Upon refresh of a node moved by another session it must be moved to the new destination (or removed).", (boolean)p.equals(this.destinationPath));
            }
            catch (InvalidItemStateException invalidItemStateException) {
                // empty catch block
            }
        }
        finally {
            readSession.logout();
        }
    }
}

