/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTrueTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(RefreshTrueTest.class);
    private Value testValue;

    protected void setUp() throws Exception {
        super.setUp();
        this.testValue = this.testRootNode.getSession().getValueFactory().createValue("anyString");
        if (!this.testRootNode.getPrimaryNodeType().canSetProperty(this.propertyName1, this.testValue)) {
            throw new NotExecutableException("");
        }
    }

    protected void tearDown() throws Exception {
        this.testValue = null;
        super.tearDown();
    }

    public void testNewNode() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName2);
        Property p = n.setProperty(this.propertyName1, this.testValue);
        this.testRootNode.refresh(true);
        String msg = "Refresh 'true' must not affect the new Node/Property.";
        RefreshTrueTest.assertTrue((String)msg, (boolean)this.testRootNode.hasNode(this.nodeName2));
        RefreshTrueTest.assertTrue((String)msg, (boolean)n.isNew());
        RefreshTrueTest.assertTrue((String)msg, (boolean)n.hasProperty(this.propertyName1));
        p.getString();
        RefreshTrueTest.assertTrue((String)msg, (boolean)p.isSame((Item)n.getProperty(this.propertyName1)));
    }

    public void testNewProperty() throws RepositoryException {
        Property p = this.testRootNode.setProperty(this.propertyName1, this.testValue);
        this.testRootNode.refresh(true);
        p.getString();
        RefreshTrueTest.assertTrue((String)"Refresh 'true' must not affect a new Property.", (boolean)this.testRootNode.hasProperty(this.propertyName1));
        Property pAgain = this.testRootNode.getProperty(this.propertyName1);
        RefreshTrueTest.assertTrue((String)"Refresh 'true' must not affect a new Property.", (boolean)p.isSame((Item)pAgain));
    }

    public void testRemovedProperty() throws RepositoryException {
        Property p = this.testRootNode.setProperty(this.propertyName1, this.testValue);
        this.testRootNode.save();
        p.remove();
        this.testRootNode.refresh(true);
        try {
            p.getString();
            RefreshTrueTest.fail((String)"Refresh 'true' must not revert removal of an item.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        RefreshTrueTest.assertFalse((String)"Refresh 'true' must not revert removal of an item.", (boolean)this.testRootNode.hasProperty(this.propertyName1));
    }

    public void testRemovedNewItem() throws RepositoryException {
        Node n = this.testRootNode.addNode(this.nodeName2);
        Property p = n.setProperty(this.propertyName1, this.testValue);
        n.remove();
        this.testRootNode.refresh(true);
        String msg = "Refresh 'true' must revert the removal of new a Node/Property.";
        RefreshTrueTest.assertFalse((String)msg, (boolean)this.testRootNode.hasNode(this.nodeName2));
        RefreshTrueTest.assertFalse((String)msg, (n.isNew() && n.isModified() ? 1 : 0) != 0);
        RefreshTrueTest.assertFalse((String)msg, (p.isNew() && p.isModified() ? 1 : 0) != 0);
        try {
            n.hasProperty(this.propertyName1);
            RefreshTrueTest.fail((String)msg);
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            p.getString();
            RefreshTrueTest.fail((String)msg);
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }
}

