/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoveItemTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(RemoveItemTest.class);
    protected Item removeItem;
    protected String removePath;

    protected void setUp() throws Exception {
        super.setUp();
        this.removeItem = this.createRemoveItem();
        this.removePath = this.removeItem.getPath();
    }

    protected void tearDown() throws Exception {
        this.removeItem = null;
        super.tearDown();
    }

    protected abstract Item createRemoveItem() throws NotExecutableException, RepositoryException, LockException, ConstraintViolationException, ItemExistsException, NoSuchNodeTypeException, VersionException;

    public void testRemoveItem() throws RepositoryException {
        this.removeItem.remove();
        try {
            this.superuser.getItem(this.removePath);
            RemoveItemTest.fail((String)"A transiently removed item should no longer be accessible from the session.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveItem2() throws RepositoryException, NotExecutableException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            this.superuser.getItem(this.removePath);
            RemoveItemTest.fail((String)"Persistently removed node should no longer be accessible from the session.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testNotNewRemovedItem() throws RepositoryException {
        this.removeItem.remove();
        RemoveItemTest.assertFalse((String)"Transiently removed node must not be 'new'.", (boolean)this.removeItem.isNew());
    }

    public void testNotNewRemovedItem2() throws RepositoryException {
        this.removeItem.remove();
        this.testRootNode.save();
        RemoveItemTest.assertFalse((String)"Removed node must not be 'new'.", (boolean)this.removeItem.isNew());
    }

    public void testNotModifiedRemovedItem() throws RepositoryException {
        this.removeItem.remove();
        RemoveItemTest.assertFalse((String)"Transiently removed node must not be 'modified'.", (boolean)this.removeItem.isModified());
    }

    public void testNotModifiedRemovedItem2() throws RepositoryException {
        this.removeItem.remove();
        this.testRootNode.save();
        RemoveItemTest.assertFalse((String)"Removed node must not be 'modified'.", (boolean)this.removeItem.isModified());
    }

    public void testInvalidStateRemovedItem() throws RepositoryException {
        this.removeItem.remove();
        try {
            this.removeItem.getName();
            RemoveItemTest.fail((String)"Calling getName() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeItem.getPath();
            RemoveItemTest.fail((String)"Calling getPath() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeItem.save();
            RemoveItemTest.fail((String)"Calling save() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testInvalidStateRemovedItem2() throws RepositoryException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            this.removeItem.getName();
            RemoveItemTest.fail((String)"Calling getName() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeItem.getPath();
            RemoveItemTest.fail((String)"Calling getPath() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeItem.save();
            RemoveItemTest.fail((String)"Calling save() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }
}

