/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveMovedNodeTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(RemoveMovedNodeTest.class);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testRemove() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.doMove(srcPath, this.destinationPath);
        this.testRootNode.getSession().getItem(this.destinationPath).remove();
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(srcPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(this.destinationPath));
        this.testRootNode.save();
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(srcPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(this.destinationPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.destParentNode.isModified());
        RemoveMovedNodeTest.assertFalse((boolean)this.srcParentNode.isModified());
    }

    public void testRevert() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.doMove(srcPath, this.destinationPath);
        this.testRootNode.getSession().getItem(this.destinationPath).remove();
        this.testRootNode.refresh(false);
        RemoveMovedNodeTest.assertTrue((boolean)this.superuser.itemExists(srcPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(this.destinationPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.moveNode.isModified());
        RemoveMovedNodeTest.assertFalse((boolean)this.destParentNode.isModified());
        RemoveMovedNodeTest.assertFalse((boolean)this.srcParentNode.isModified());
    }

    public void testRefresh() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.doMove(srcPath, this.destinationPath);
        this.testRootNode.getSession().getItem(this.destinationPath).remove();
        this.testRootNode.refresh(true);
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(srcPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(this.destinationPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.moveNode.isModified());
        RemoveMovedNodeTest.assertTrue((boolean)this.destParentNode.isModified());
        RemoveMovedNodeTest.assertTrue((boolean)this.srcParentNode.isModified());
    }

    public void testRemoveSrcParent() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.doMove(srcPath, this.destinationPath);
        this.srcParentNode.remove();
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(srcPath));
        RemoveMovedNodeTest.assertTrue((boolean)this.superuser.itemExists(this.destinationPath));
        RemoveMovedNodeTest.assertTrue((boolean)this.moveNode.isModified());
        RemoveMovedNodeTest.assertTrue((boolean)this.destParentNode.isModified());
        RemoveMovedNodeTest.assertFalse((boolean)this.srcParentNode.isModified());
        this.testRootNode.refresh(false);
        RemoveMovedNodeTest.assertTrue((boolean)this.superuser.itemExists(srcPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.superuser.itemExists(this.destinationPath));
        RemoveMovedNodeTest.assertFalse((boolean)this.moveNode.isModified());
        RemoveMovedNodeTest.assertFalse((boolean)this.destParentNode.isModified());
        RemoveMovedNodeTest.assertFalse((boolean)this.srcParentNode.isModified());
    }
}

