/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveNewNodeTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(RemoveNewNodeTest.class);
    protected Node removeNode;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.testRootNode.hasNode(this.nodeName1)) {
            throw new NotExecutableException("Parent node must not yet contain a child node '" + this.nodeName1 + "'.");
        }
        this.removeNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
    }

    protected void tearDown() throws Exception {
        this.removeNode = null;
        super.tearDown();
    }

    public void testRemoveNode() throws RepositoryException {
        this.removeNode.remove();
        try {
            this.testRootNode.getNode(this.nodeName1);
            RemoveNewNodeTest.fail((String)"Removed transient node should no longer be accessible from parent node.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testNotNewRemovedNode() throws RepositoryException {
        this.removeNode.remove();
        RemoveNewNodeTest.assertFalse((String)"Removed transient node must not be 'new'.", (boolean)this.removeNode.isNew());
    }

    public void testNotModifiedRemovedNode() throws RepositoryException {
        this.removeNode.remove();
        RemoveNewNodeTest.assertFalse((String)"Removed transient node must not be 'modified'.", (boolean)this.removeNode.isModified());
    }

    public void testInvalidStateRemovedNode() throws RepositoryException {
        this.removeNode.remove();
        try {
            this.removeNode.getName();
            RemoveNewNodeTest.fail((String)"Calling getName() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeNode.getPath();
            RemoveNewNodeTest.fail((String)"Calling getPath() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeNode.getPrimaryNodeType();
            RemoveNewNodeTest.fail((String)"Calling getPrimaryNodeType() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeNode.getProperty(this.jcrPrimaryType);
            RemoveNewNodeTest.fail((String)"Calling getProperty(String) on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            this.removeNode.save();
            RemoveNewNodeTest.fail((String)"Calling save() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }
}

