/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.RemoveItemTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveNodeTest
extends RemoveItemTest {
    private static Logger log = LoggerFactory.getLogger(RemoveNodeTest.class);

    @Override
    protected Item createRemoveItem() throws NotExecutableException, RepositoryException {
        if (this.testRootNode.hasNode(this.nodeName1)) {
            throw new NotExecutableException("Parent node must not yet contain a child node '" + this.nodeName1 + "'.");
        }
        Node removeNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        return removeNode;
    }

    public void testRemoveNode() throws RepositoryException {
        this.removeItem.remove();
        try {
            String relPath = this.removePath.substring(this.removePath.lastIndexOf(47) + 1);
            this.testRootNode.getNode(relPath);
            RemoveNodeTest.fail((String)"Transiently removed node should no longer be accessible from parent node.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveNode2() throws RepositoryException, NotExecutableException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            String relPath = this.removePath.substring(this.removePath.lastIndexOf(47) + 1);
            this.testRootNode.getNode(relPath);
            RemoveNodeTest.fail((String)"Persistently removed node should no longer be accessible from parent node.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testInvalidStateRemovedNode() throws RepositoryException {
        this.removeItem.remove();
        try {
            ((Node)this.removeItem).getPrimaryNodeType();
            RemoveNodeTest.fail((String)"Calling getPrimaryNodeType() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            ((Node)this.removeItem).getProperty(this.jcrPrimaryType);
            RemoveNodeTest.fail((String)"Calling getProperty(String) on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testInvalidStateRemovedNode2() throws RepositoryException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            ((Node)this.removeItem).getPrimaryNodeType();
            RemoveNodeTest.fail((String)"Calling getPrimaryNodeType() on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            ((Node)this.removeItem).getProperty(this.jcrPrimaryType);
            RemoveNodeTest.fail((String)"Calling getProperty(String) on a removed node must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidStateRemovedNode3() throws RepositoryException {
        Node childNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.superuser.save();
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            Node childNode2 = (Node)otherSession.getItem(childNode.getPath());
            childNode.remove();
            this.superuser.save();
            try {
                childNode2.refresh(false);
                childNode2.remove();
                otherSession.save();
                RemoveNodeTest.fail((String)"Removing a node already removed by other session should throw an InvalidItemStateException!");
            }
            catch (InvalidItemStateException invalidItemStateException) {
                // empty catch block
            }
        }
        finally {
            otherSession.logout();
        }
    }
}

