/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.RemoveItemTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovePropertyTest
extends RemoveItemTest {
    private static Logger log = LoggerFactory.getLogger(RemovePropertyTest.class);

    @Override
    protected Item createRemoveItem() throws NotExecutableException, RepositoryException, LockException, ConstraintViolationException, ItemExistsException, NoSuchNodeTypeException, VersionException {
        Property removeProperty;
        if (this.testRootNode.hasProperty(this.propertyName1)) {
            removeProperty = this.testRootNode.getProperty(this.propertyName1);
            if (removeProperty.getDefinition().isProtected() || removeProperty.getDefinition().isMandatory()) {
                throw new NotExecutableException("Property to be remove must be mandatory nor protected '" + this.propertyName1 + "'.");
            }
        } else {
            removeProperty = this.testRootNode.setProperty(this.propertyName1, "anyString");
        }
        this.testRootNode.save();
        return removeProperty;
    }

    public void testRemoveProperty() throws RepositoryException {
        this.removeItem.remove();
        try {
            this.testRootNode.getProperty(this.propertyName1);
            RemovePropertyTest.fail((String)"Transiently removed property should no longer be accessible from parent node.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveProperty2() throws RepositoryException, NotExecutableException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            this.testRootNode.getProperty(this.propertyName1);
            RemovePropertyTest.fail((String)"Permanently removed property should no longer be accessible from parent node.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testInvalidStateRemovedProperty() throws RepositoryException {
        this.removeItem.remove();
        try {
            ((Property)this.removeItem).getType();
            RemovePropertyTest.fail((String)"Calling getType() on a removed property must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            ((Property)this.removeItem).getValue();
            RemovePropertyTest.fail((String)"Calling getValue() on a removed property must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testInvalidStateRemovedProperty2() throws RepositoryException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            ((Property)this.removeItem).getType();
            RemovePropertyTest.fail((String)"Calling getType() on a removed property must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
        try {
            ((Property)this.removeItem).getValue();
            RemovePropertyTest.fail((String)"Calling getValue() on a removed property must throw InvalidItemStateException.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }
}

