/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.RemoveNodeTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveReferenceableNodeTest
extends RemoveNodeTest {
    private static Logger log = LoggerFactory.getLogger(RemoveReferenceableNodeTest.class);
    private String uuid;

    @Override
    protected Item createRemoveItem() throws NotExecutableException, RepositoryException {
        Node removeItem = (Node)super.createRemoveItem();
        if (!removeItem.isNodeType(this.mixReferenceable)) {
            if (!removeItem.canAddMixin(this.mixReferenceable)) {
                throw new NotExecutableException("Cannot make remove-node '" + this.nodeName1 + "' mix:referenceable.");
            }
            removeItem.addMixin(this.mixReferenceable);
        }
        this.testRootNode.save();
        this.uuid = removeItem.getUUID();
        return removeItem;
    }

    public void testAccessByUUID() throws RepositoryException {
        this.removeItem.remove();
        try {
            this.superuser.getNodeByUUID(this.uuid);
            RemoveReferenceableNodeTest.fail((String)"Transiently removed node should no longer be accessible from parent node.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testAccessByUUID2() throws RepositoryException, NotExecutableException {
        this.removeItem.remove();
        this.testRootNode.save();
        try {
            this.superuser.getNodeByUUID(this.uuid);
            RemoveReferenceableNodeTest.fail((String)"Permanently removed node should no longer be accessible from parent node.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }
}

