/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.RemoveNodeTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveSNSTest
extends RemoveNodeTest {
    private static Logger log = LoggerFactory.getLogger(RemoveSNSTest.class);
    private Node firstSiblingNode;
    private String firstSiblingPath;

    @Override
    protected void tearDown() throws Exception {
        this.firstSiblingNode = null;
        super.tearDown();
    }

    @Override
    protected Item createRemoveItem() throws NotExecutableException, RepositoryException {
        if (this.testRootNode.hasNode(this.nodeName1)) {
            RemoveSNSTest.fail((String)("Setup: Parent node must not yet contain a child node '" + this.nodeName1 + "'."));
        }
        this.firstSiblingNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        if (!this.firstSiblingNode.getDefinition().allowsSameNameSiblings()) {
            RemoveSNSTest.fail((String)"Setup: RemoveSNSTest cannot be execute. Unable to create SameNameSiblings.");
        }
        this.firstSiblingPath = this.firstSiblingNode.getPath();
        Node removeNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        return removeNode;
    }

    public void testRemoveFirstSibling() throws RepositoryException {
        this.firstSiblingNode.remove();
        try {
            Node secondSibling = this.testRootNode.getNode(this.nodeName1);
            RemoveSNSTest.assertTrue((String)"", (boolean)this.removeItem.isSame((Item)secondSibling));
        }
        catch (PathNotFoundException e) {
            RemoveSNSTest.fail((String)"Second sibling must still be available.");
        }
    }

    public void testRemoveFirstSibling2() throws RepositoryException, NotExecutableException {
        this.firstSiblingNode.remove();
        this.testRootNode.save();
        try {
            Node secondSibling = this.testRootNode.getNode(this.nodeName1);
            RemoveSNSTest.assertTrue((String)"", (boolean)this.removeItem.isSame((Item)secondSibling));
        }
        catch (PathNotFoundException e) {
            RemoveSNSTest.fail((String)"Second sibling must still be available.");
        }
    }

    public void testRemoveFirstSibling3() throws RepositoryException {
        this.firstSiblingNode.remove();
        try {
            Item secondSibling = this.superuser.getItem(this.firstSiblingPath);
            RemoveSNSTest.assertTrue((String)"", (boolean)this.removeItem.isSame(secondSibling));
        }
        catch (PathNotFoundException e) {
            RemoveSNSTest.fail((String)"Removing a SNS Node -> successor must be accessible from the session by removed path.");
        }
    }

    public void testRemoveFirstSibling4() throws RepositoryException {
        this.firstSiblingNode.remove();
        this.testRootNode.save();
        try {
            Item secondSibling = this.superuser.getItem(this.firstSiblingPath);
            RemoveSNSTest.assertTrue((String)"", (boolean)this.removeItem.isSame(secondSibling));
        }
        catch (PathNotFoundException e) {
            RemoveSNSTest.fail((String)"Removing a SNS Node -> successor must be accessible from the session by removed path.");
        }
    }
}

