/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(RenameTest.class);
    private String renamedName;
    private String renamePath;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.renamedName = "renamed";
        this.renamePath = this.srcParentNode.getPath() + "/" + this.renamedName;
    }

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testRename() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.renamePath);
        RenameTest.assertEquals((String)this.moveNode.getName(), (String)this.renamedName);
        this.superuser.save();
        RenameTest.assertEquals((String)this.moveNode.getName(), (String)this.renamedName);
    }

    public void testRevertRename() throws RepositoryException {
        this.doMove(this.moveNode.getPath(), this.renamePath);
        RenameTest.assertEquals((String)this.moveNode.getName(), (String)this.renamedName);
        this.superuser.refresh(false);
        RenameTest.assertEquals((String)this.moveNode.getName(), (String)this.nodeName2);
    }
}

