/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderMoveTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(ReorderMoveTest.class);
    private Node destParent;
    private Node srcParent;
    private String destPath;

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.testRootNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new NotExecutableException("Test node does not have orderable children.");
        }
        this.destParent = this.testRootNode.addNode(this.nodeName4, this.testNodeType);
        this.srcParent = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.destPath = this.destParent.getPath() + "/" + this.nodeName3;
        this.testRootNode.save();
    }

    protected void tearDown() throws Exception {
        this.destParent = null;
        this.srcParent = null;
        super.tearDown();
    }

    private Node[] createOrderableChildren(boolean sns) throws RepositoryException {
        String[] childNames = sns ? new String[]{this.nodeName2, this.nodeName2, this.nodeName2, this.nodeName2} : new String[]{this.nodeName1, this.nodeName2, this.nodeName3, this.nodeName4};
        Node[] children = new Node[]{this.srcParent.addNode(childNames[0], this.testNodeType), this.srcParent.addNode(childNames[1], this.testNodeType), this.srcParent.addNode(childNames[2], this.testNodeType), this.srcParent.addNode(childNames[3], this.testNodeType)};
        this.testRootNode.save();
        return children;
    }

    private static String getRelPath(Node child) throws RepositoryException {
        if (child == null) {
            return null;
        }
        String path = child.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private static void testOrder(Node parent, Node[] children) throws RepositoryException {
        NodeIterator it = parent.getNodes();
        int i = 0;
        while (it.hasNext()) {
            Node child = it.nextNode();
            ReorderMoveTest.assertTrue((boolean)child.isSame((Item)children[i]));
            ++i;
        }
    }

    public void testMoveAndReorder() throws RepositoryException {
        Node[] children = this.createOrderableChildren(false);
        String oldName = children[2].getName();
        this.testRootNode.getSession().move(children[2].getPath(), this.destPath);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[1]), null);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[0], children[3], children[1]});
        this.testRootNode.save();
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[0], children[3], children[1]});
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(oldName));
    }

    public void testMoveAndReorderSNS() throws RepositoryException {
        Node[] children = this.createOrderableChildren(true);
        String snsName = children[0].getName();
        this.testRootNode.getSession().move(children[2].getPath(), this.destPath);
        this.testRootNode.getSession().move(children[1].getPath(), this.destPath);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[0]), null);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[3], children[0]});
        ReorderMoveTest.assertTrue((boolean)this.srcParent.hasNode(snsName + "[1]"));
        ReorderMoveTest.assertTrue((boolean)this.srcParent.hasNode(snsName + "[2]"));
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(snsName + "[3]"));
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(snsName + "[4]"));
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(snsName + "[5]"));
        this.testRootNode.save();
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[3], children[0]});
        ReorderMoveTest.assertTrue((boolean)this.srcParent.hasNode(snsName + "[1]"));
        ReorderMoveTest.assertTrue((boolean)this.srcParent.hasNode(snsName + "[2]"));
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(snsName + "[3]"));
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(snsName + "[4]"));
        ReorderMoveTest.assertFalse((boolean)this.srcParent.hasNode(snsName + "[5]"));
        ReorderMoveTest.assertEquals((String)children[2].getPath(), (String)this.destPath);
        ReorderMoveTest.assertTrue((children[2].getIndex() == 1 ? 1 : 0) != 0);
        ReorderMoveTest.assertEquals((String)children[1].getPath(), (String)(this.destPath + "[2]"));
    }

    public void testReorderAndMove() throws RepositoryException {
        Node[] children = this.createOrderableChildren(false);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[0]), null);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[3]), ReorderMoveTest.getRelPath(children[1]));
        this.testRootNode.getSession().move(children[3].getPath(), this.destPath);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[1], children[2], children[0]});
        this.testRootNode.save();
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[1], children[2], children[0]});
    }

    public void testReorderAndMoveSNS() throws RepositoryException {
        Node[] children = this.createOrderableChildren(true);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[0]), null);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[3]), ReorderMoveTest.getRelPath(children[1]));
        this.testRootNode.getSession().move(children[3].getPath(), this.destPath);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[1], children[2], children[0]});
        this.testRootNode.save();
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[1], children[2], children[0]});
    }

    public void testReorderMovedNode() throws RepositoryException {
        Node[] children = this.createOrderableChildren(false);
        String relPath = ReorderMoveTest.getRelPath(children[2]);
        this.testRootNode.getSession().move(children[2].getPath(), this.destPath);
        try {
            this.srcParent.orderBefore(relPath, null);
            ReorderMoveTest.fail((String)"Reordering a child node that has been moved away must fail.");
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    public void testRevertMoveAndReorderSNS() throws RepositoryException {
        Node[] children = this.createOrderableChildren(true);
        this.testRootNode.getSession().move(children[2].getPath(), this.destPath);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[1]), null);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[3]), ReorderMoveTest.getRelPath(children[0]));
        this.testRootNode.refresh(false);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[0], children[1], children[2], children[3]});
        ReorderMoveTest.assertFalse((boolean)this.destParent.hasNode(Text.getName((String)this.destPath)));
    }

    public void testRevertReorderAndMoveSNS() throws RepositoryException {
        Node[] children = this.createOrderableChildren(true);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[1]), null);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[3]), ReorderMoveTest.getRelPath(children[2]));
        this.srcParent.getSession().move(children[2].getPath(), this.destPath);
        this.testRootNode.refresh(false);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[0], children[1], children[2], children[3]});
        ReorderMoveTest.assertFalse((boolean)this.destParent.hasNode(Text.getName((String)this.destPath)));
    }

    public void testRevertMoveReorderedSNS() throws RepositoryException {
        Node[] children = this.createOrderableChildren(true);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[1]), null);
        this.srcParent.orderBefore(ReorderMoveTest.getRelPath(children[3]), ReorderMoveTest.getRelPath(children[2]));
        this.srcParent.getSession().move(children[1].getPath(), this.destPath);
        this.testRootNode.refresh(false);
        ReorderMoveTest.testOrder(this.srcParent, new Node[]{children[0], children[1], children[2], children[3]});
        ReorderMoveTest.assertFalse((boolean)this.destParent.hasNode(Text.getName((String)this.destPath)));
    }
}

