/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ReorderTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderNewSNSTest
extends ReorderTest {
    private static Logger log = LoggerFactory.getLogger(ReorderNewSNSTest.class);

    @Override
    protected void createOrderableChildren() throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        this.child1 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child3 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child4 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
    }

    @Override
    public void testRevertReorder() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderNewSNSTest.getRelPath(this.child4), ReorderNewSNSTest.getRelPath(this.child2));
        ReorderNewSNSTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child4, this.child2, this.child3});
        this.testRootNode.refresh(false);
        NodeIterator it = this.testRootNode.getNodes(this.nodeName2);
        if (it.hasNext()) {
            ReorderNewSNSTest.fail((String)"Reverting creation and reordering of new SNSs must remove the children again.");
        }
    }

    @Override
    public void testRevertReorderToEnd() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderNewSNSTest.getRelPath(this.child1), null);
        ReorderNewSNSTest.testOrder(this.testRootNode, new Node[]{this.child2, this.child3, this.child4, this.child1});
        this.testRootNode.refresh(false);
        NodeIterator it = this.testRootNode.getNodes(this.nodeName2);
        if (it.hasNext()) {
            ReorderNewSNSTest.fail((String)"Reverting creation and reordering of new SNSs must remove the children again.");
        }
    }
}

