/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ReorderTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderNewTest
extends ReorderTest {
    private static Logger log = LoggerFactory.getLogger(ReorderNewTest.class);

    @Override
    protected void createOrderableChildren() throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        this.child1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.child2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.child4 = this.testRootNode.addNode(this.nodeName4, this.testNodeType);
    }

    @Override
    public void testRevertReorder() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderNewTest.getRelPath(this.child4), ReorderNewTest.getRelPath(this.child2));
        ReorderNewTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child4, this.child2, this.child3});
        this.testRootNode.refresh(false);
        NodeIterator it = this.testRootNode.getNodes();
        if (it.hasNext()) {
            ReorderNewTest.fail((String)"Reverting creation and reordering of new children must remove the children again.");
        }
    }

    @Override
    public void testRevertReorderToEnd() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderNewTest.getRelPath(this.child1), null);
        ReorderNewTest.testOrder(this.testRootNode, new Node[]{this.child2, this.child3, this.child4, this.child1});
        this.testRootNode.refresh(false);
        NodeIterator it = this.testRootNode.getNodes();
        if (it.hasNext()) {
            ReorderNewTest.fail((String)"Reverting creation and reordering of new children must remove the children again.");
        }
    }
}

