/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ReorderTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderSNSTest
extends ReorderTest {
    private static Logger log = LoggerFactory.getLogger(ReorderSNSTest.class);

    @Override
    protected void createOrderableChildren() throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        this.child1 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child3 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child4 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
    }

    public void testIndexAfterReorder() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderSNSTest.getRelPath(this.child1), ReorderSNSTest.getRelPath(this.child3));
        ReorderSNSTest.assertTrue((this.child1.getIndex() == 2 ? 1 : 0) != 0);
        ReorderSNSTest.assertTrue((this.child2.getIndex() == 1 ? 1 : 0) != 0);
        ReorderSNSTest.assertTrue((this.child3.getIndex() == 3 ? 1 : 0) != 0);
        ReorderSNSTest.assertTrue((this.child4.getIndex() == 4 ? 1 : 0) != 0);
        this.testRootNode.save();
        ReorderSNSTest.assertTrue((this.child1.getIndex() == 2 ? 1 : 0) != 0);
        ReorderSNSTest.assertTrue((this.child2.getIndex() == 1 ? 1 : 0) != 0);
        ReorderSNSTest.assertTrue((this.child3.getIndex() == 3 ? 1 : 0) != 0);
        ReorderSNSTest.assertTrue((this.child4.getIndex() == 4 ? 1 : 0) != 0);
    }

    public void testReorder3() throws RepositoryException {
        String pathBefore = this.child3.getPath();
        this.testRootNode.orderBefore(ReorderSNSTest.getRelPath(this.child3), ReorderSNSTest.getRelPath(this.child1));
        this.testRootNode.save();
        Item itemIndex3 = this.testRootNode.getSession().getItem(pathBefore);
        ReorderSNSTest.assertTrue((boolean)itemIndex3.isSame((Item)this.child2));
        Item item3 = this.testRootNode.getSession().getItem(this.child3.getPath());
        ReorderSNSTest.assertTrue((boolean)item3.isSame((Item)this.child3));
    }
}

