/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(ReorderTest.class);
    protected Node child1;
    protected Node child2;
    protected Node child3;
    protected Node child4;

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.testRootNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new NotExecutableException("Test node does not have orderable children.");
        }
        NodeIterator it = this.testRootNode.getNodes();
        if (it.hasNext()) {
            throw new NotExecutableException("Test node already contains child nodes");
        }
        this.createOrderableChildren();
    }

    protected void tearDown() throws Exception {
        this.child1 = null;
        this.child2 = null;
        this.child3 = null;
        this.child4 = null;
        super.tearDown();
    }

    protected void createOrderableChildren() throws RepositoryException, LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException, NotExecutableException {
        this.child1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.child2 = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.child3 = this.testRootNode.addNode(this.nodeName3, this.testNodeType);
        this.child4 = this.testRootNode.addNode(this.nodeName4, this.testNodeType);
        this.testRootNode.save();
    }

    protected static String getRelPath(Node child) throws RepositoryException {
        if (child == null) {
            return null;
        }
        String path = child.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    protected static void testOrder(Node parent, Node[] children) throws RepositoryException {
        NodeIterator it = parent.getNodes();
        int i = 0;
        while (it.hasNext()) {
            Node child = it.nextNode();
            if (i >= children.length) {
                ReorderTest.fail((String)"Reorder added a child node.");
            }
            ReorderTest.assertTrue((String)("Wrong order of children: " + child + " is not the same as " + children[i]), (boolean)child.isSame((Item)children[i]));
            ++i;
        }
        if (i < children.length - 1) {
            ReorderTest.fail((String)"Reorder removed a child node.");
        }
    }

    public void testReorder() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child1), ReorderTest.getRelPath(this.child3));
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child2, this.child1, this.child3, this.child4});
        this.testRootNode.save();
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child2, this.child1, this.child3, this.child4});
    }

    public void testReorderToEnd() throws RepositoryException, ConstraintViolationException, UnsupportedRepositoryOperationException, VersionException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child2), null);
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child3, this.child4, this.child2});
        this.testRootNode.save();
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child3, this.child4, this.child2});
    }

    public void testRevertReorder() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child4), ReorderTest.getRelPath(this.child2));
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child4, this.child2, this.child3});
        this.testRootNode.refresh(false);
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child2, this.child3, this.child4});
    }

    public void testRevertReorderToEnd() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child1), null);
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child2, this.child3, this.child4, this.child1});
        this.testRootNode.refresh(false);
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child2, this.child3, this.child4});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReorder2() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child3), ReorderTest.getRelPath(this.child1));
        this.testRootNode.save();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            ReorderTest.testOrder((Node)otherSession.getItem(this.testRootNode.getPath()), new Node[]{this.child3, this.child1, this.child2, this.child4});
        }
        finally {
            otherSession.logout();
        }
    }

    public void testReorderTwice() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child2), null);
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child4), ReorderTest.getRelPath(this.child1));
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child4, this.child1, this.child3, this.child2});
        this.testRootNode.save();
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child4, this.child1, this.child3, this.child2});
    }

    public void testReorderFinallyOriginalOrder() throws RepositoryException {
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child4), ReorderTest.getRelPath(this.child1));
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child3), ReorderTest.getRelPath(this.child4));
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child2), ReorderTest.getRelPath(this.child3));
        this.testRootNode.orderBefore(ReorderTest.getRelPath(this.child1), ReorderTest.getRelPath(this.child2));
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child2, this.child3, this.child4});
        this.testRootNode.save();
        ReorderTest.testOrder(this.testRootNode, new Node[]{this.child1, this.child2, this.child3, this.child4});
    }
}

