/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceNodeTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(ReplaceNodeTest.class);
    private Node removeNode;
    private String uuid;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.testRootNode.hasNode(this.nodeName1)) {
            throw new NotExecutableException("Parent node must not yet contain a child node '" + this.nodeName1 + "'.");
        }
        this.removeNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.save();
        if (!this.removeNode.isNodeType(this.mixReferenceable)) {
            if (!this.removeNode.canAddMixin(this.mixReferenceable)) {
                throw new NotExecutableException("Cannot make remove-node '" + this.nodeName1 + "' mix:referenceable.");
            }
            this.removeNode.addMixin(this.mixReferenceable);
            this.testRootNode.save();
        }
        this.uuid = this.removeNode.getUUID();
    }

    protected void tearDown() throws Exception {
        this.removeNode = null;
        super.tearDown();
    }

    public void testAddReplacementAfterRemove() throws RepositoryException {
        this.removeNode.remove();
        Node n = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        n.addNode(this.nodeName3, this.testNodeType);
        this.testRootNode.save();
        try {
            ReplaceNodeTest.assertFalse((boolean)this.uuid.equals(n.getUUID()));
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testAddReplacementAfterMove() throws RepositoryException {
        this.superuser.move(this.removeNode.getPath(), this.testRootNode.getPath() + "/" + this.nodeName4);
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        n.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        try {
            ReplaceNodeTest.assertFalse((boolean)this.uuid.equals(n.getUUID()));
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }
}

