/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.AbstractMoveTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevertMoveTest
extends AbstractMoveTest {
    private static Logger log = LoggerFactory.getLogger(RevertMoveTest.class);

    @Override
    protected boolean isSessionMove() {
        return true;
    }

    public void testRevertMovedNode() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.doMove(srcPath, this.destinationPath);
        Node afterMoveNode = (Node)this.testRootNode.getSession().getItem(this.destinationPath);
        try {
            afterMoveNode.refresh(false);
            RevertMoveTest.fail((String)"Node.refresh() on a transiently moved node should fail such as a 'save' would fail.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testRevertMoveOperation() throws RepositoryException {
        String srcPath = this.moveNode.getPath();
        this.doMove(srcPath, this.destinationPath);
        this.testRootNode.getSession().refresh(false);
        RevertMoveTest.assertFalse((String)"Reverting the move operation must remove the node at destination path.", (boolean)this.testRootNode.getSession().itemExists(this.destinationPath));
        RevertMoveTest.assertTrue((String)"Reverting the move operation must re-add the node at its original position.", (boolean)this.testRootNode.getSession().itemExists(srcPath));
        RevertMoveTest.assertTrue((String)"Reverting the move operation must re-add the node at its original position.", (boolean)srcPath.equals(this.moveNode.getPath()));
        RevertMoveTest.assertFalse((String)"The former destination must not be modified.", (boolean)this.destParentNode.isModified());
        RevertMoveTest.assertFalse((String)"The parent must not be modified.", (boolean)this.srcParentNode.isModified());
        RevertMoveTest.assertFalse((String)"The move-node must not be modified.", (boolean)this.moveNode.isModified());
    }
}

