/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SNSIndexTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(SNSIndexTest.class);
    private String snsName;
    private Node parent;
    private Node sns1;
    private Node sns2;
    private Node sns3;
    private Node sns4;
    private String snsPath;

    protected void setUp() throws Exception {
        super.setUp();
        this.snsName = this.nodeName2;
        this.parent = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.sns1 = this.parent.addNode(this.snsName, this.testNodeType);
        this.sns2 = this.parent.addNode(this.snsName, this.testNodeType);
        this.sns3 = this.parent.addNode(this.snsName, this.testNodeType);
        this.sns4 = this.parent.addNode(this.snsName, this.testNodeType);
        this.testRootNode.save();
        this.snsPath = this.testRootNode.getPath() + "/" + this.nodeName1 + "/" + this.snsName;
    }

    protected void tearDown() throws Exception {
        this.parent = null;
        this.sns1 = null;
        this.sns2 = null;
        this.sns3 = null;
        this.sns4 = null;
        super.tearDown();
    }

    public void testIndex() throws RepositoryException {
        SNSIndexTest.checkIndex(this.sns1, 1);
        SNSIndexTest.checkIndex(this.sns2, 2);
        SNSIndexTest.checkIndex(this.sns3, 3);
        SNSIndexTest.checkIndex(this.sns4, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexByOtherSession() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            for (int index = 1; index < 4; ++index) {
                Node sns = (Node)otherSession.getItem(this.buildPath(index));
                SNSIndexTest.checkIndex(sns, index);
            }
        }
        finally {
            otherSession.logout();
        }
    }

    public void testNonExistingIndex() throws RepositoryException {
        try {
            this.superuser.getItem(this.buildPath(10));
            SNSIndexTest.fail((String)"Accessing item with non-existing index must throw PathNotFoundException.");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testDefaultIndex() throws RepositoryException {
        Node sns = this.parent.getNode(this.snsName);
        SNSIndexTest.checkIndex(sns, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeEntriesFilledCorrectly() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            Node sns = (Node)otherSession.getItem(this.buildPath(3));
            SNSIndexTest.checkIndex(sns, 3);
            sns = (Node)otherSession.getItem(this.buildPath(2));
            SNSIndexTest.checkIndex(sns, 2);
            sns = (Node)otherSession.getItem(this.buildPath(4));
            SNSIndexTest.checkIndex(sns, 4);
            sns = (Node)otherSession.getItem(this.buildPath(3));
            SNSIndexTest.checkIndex(sns, 3);
            sns = (Node)otherSession.getItem(this.buildPath(1));
            SNSIndexTest.checkIndex(sns, 1);
        }
        finally {
            otherSession.logout();
        }
    }

    public void testGetNodesByName() throws RepositoryException {
        NodeIterator it = this.parent.getNodes(this.snsName);
        long size = it.getSize();
        if (size != -1L) {
            SNSIndexTest.assertTrue((String)("4 SNSs have been added -> but iterator size is " + size + "."), (size == 4L ? 1 : 0) != 0);
        }
        int expectedIndex = 1;
        while (it.hasNext()) {
            Node sns = it.nextNode();
            SNSIndexTest.checkIndex(sns, expectedIndex);
            ++expectedIndex;
        }
        SNSIndexTest.assertTrue((String)("4 SNSs have been added -> but iterator size is " + size + "."), (size == 4L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetNodesByNameByOtherSession() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            NodeIterator it = ((Node)otherSession.getItem(this.parent.getPath())).getNodes(this.snsName);
            long size = it.getSize();
            if (size != -1L) {
                SNSIndexTest.assertTrue((String)("4 SNSs have been added -> but iterator size is " + size + "."), (size == 4L ? 1 : 0) != 0);
            }
            int expectedIndex = 1;
            while (it.hasNext()) {
                Node sns = it.nextNode();
                SNSIndexTest.checkIndex(sns, expectedIndex);
                ++expectedIndex;
            }
            SNSIndexTest.assertTrue((String)("4 SNSs have been added -> but iterator size is " + size + "."), (size == 4L ? 1 : 0) != 0);
        }
        finally {
            otherSession.logout();
        }
    }

    private String buildPath(int index) {
        return this.snsPath + "[" + index + "]";
    }

    private static void checkIndex(Node node, int expectedIndex) throws RepositoryException {
        int index = node.getIndex();
        if (index != expectedIndex) {
            SNSIndexTest.fail((String)("Unexpected index " + index + ". Expected index was " + expectedIndex));
        }
    }
}

