/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Arrays;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(UpdateTest.class);
    private String currentWorkspace;

    protected void setUp() throws Exception {
        super.setUp();
        this.currentWorkspace = this.testRootNode.getSession().getWorkspace().getName();
    }

    public void testInvalidSrcWorkspace() throws RepositoryException {
        String nonExistingWorkspace = "nonExistingWorkspace";
        String[] accessibleWorkspaces = this.testRootNode.getSession().getWorkspace().getAccessibleWorkspaceNames();
        List<String> l = Arrays.asList(accessibleWorkspaces);
        while (l.contains(nonExistingWorkspace)) {
            nonExistingWorkspace = nonExistingWorkspace + "_";
        }
        try {
            this.testRootNode.update(nonExistingWorkspace);
        }
        catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            // empty catch block
        }
    }

    public void testNoCorrespondingNode() throws RepositoryException, NotExecutableException {
        Node n = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        String srcWorkspace = null;
        String wspName = this.getHelper().getProperty("org.apache.jackrabbit.jcr2spi.workspace2.name");
        if (wspName == null) {
            throw new NotExecutableException("Cannot run update. Missing config param.");
        }
        try {
            n.getCorrespondingNodePath(wspName);
        }
        catch (ItemNotFoundException e) {
            srcWorkspace = wspName;
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Cannot run update. Workspace " + srcWorkspace + " does not exist or is not accessible.");
        }
        if (srcWorkspace == null) {
            throw new NotExecutableException("Cannot run update. No workspace found, that misses the corresponding node.");
        }
        try {
            this.testRootNode.update(srcWorkspace);
        }
        catch (RepositoryException e) {
            UpdateTest.fail((String)"Update with workspace that doesn't contain the corresponding node must work.");
        }
    }

    public void testSameWorkspace() throws RepositoryException, NotExecutableException {
        try {
            this.testRootNode.update(this.currentWorkspace);
        }
        catch (RepositoryException e) {
            UpdateTest.fail((String)"Update with srcWorkspace == this workspace must return silently.");
        }
    }

    public void testPendingChangesSameWorkspace() throws RepositoryException, NotExecutableException {
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        try {
            this.testRootNode.update(this.currentWorkspace);
            UpdateTest.fail((String)"Update while changes are pending must fail with InvalidItemStateException");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testPendingChanges() throws RepositoryException, NotExecutableException {
        this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        String srcWorkspace = this.getAnotherWorkspace();
        try {
            this.testRootNode.update(srcWorkspace);
            UpdateTest.fail((String)"Update while changes are pending must fail with InvalidItemStateException");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testPendingChangesOnOtherNode() throws RepositoryException, NotExecutableException {
        try {
            Node root = this.testRootNode.getSession().getRootNode();
            if (root.isSame((Item)this.testRootNode)) {
                throw new NotExecutableException();
            }
            if (root.canAddMixin(this.mixLockable)) {
                root.addMixin(this.mixLockable);
            } else {
                root.setProperty(this.propertyName1, "anyValue");
            }
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        String srcWorkspace = this.getAnotherWorkspace();
        try {
            this.testRootNode.update(srcWorkspace);
            UpdateTest.fail((String)"Update while changes are pending must fail with InvalidItemStateException");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testUpdateRemovesExtraProperty() throws RepositoryException, NotExecutableException {
        this.testRootNode.setProperty(this.propertyName2, "test");
        this.testRootNode.save();
        String srcWorkspace = this.getAnotherWorkspace();
        Session session2 = this.getHelper().getSuperuserSession(srcWorkspace);
        try {
            Node testRootW2 = (Node)session2.getItem(this.testRootNode.getCorrespondingNodePath(srcWorkspace));
            if (testRootW2.hasProperty(this.propertyName2)) {
                throw new NotExecutableException();
            }
            this.testRootNode.update(srcWorkspace);
            UpdateTest.assertFalse((String)"Node updated with Node.update() should have property removed", (boolean)this.testRootNode.hasProperty(this.propertyName2));
        }
        catch (PathNotFoundException e) {
            throw new NotExecutableException();
        }
        catch (ItemNotFoundException e) {
            throw new NotExecutableException();
        }
        finally {
            session2.logout();
        }
    }

    public void testUpdateAddsMissingSubtree() throws RepositoryException, NotExecutableException {
        String srcWorkspace = this.getAnotherWorkspace();
        Session session2 = this.getHelper().getSuperuserSession(srcWorkspace);
        try {
            Node testRootW2 = (Node)session2.getItem(this.testRootNode.getCorrespondingNodePath(srcWorkspace));
            Node aNode2 = testRootW2.addNode(this.nodeName1, this.testNodeType);
            aNode2.addNode(this.nodeName2, this.testNodeType);
            aNode2.setProperty(this.propertyName2, "test");
            Property p2 = testRootW2.setProperty(this.propertyName1, "test");
            testRootW2.save();
            this.testRootNode.update(srcWorkspace);
            boolean allPresent = this.testRootNode.hasNode(this.nodeName1) && this.testRootNode.hasNode(this.nodeName1 + "/" + this.nodeName2) && this.testRootNode.hasProperty(this.nodeName1 + "/" + this.propertyName2) && this.testRootNode.hasProperty(this.propertyName1);
            UpdateTest.assertTrue((String)"Node updated with Node.update() should have received childrens", (boolean)allPresent);
        }
        catch (PathNotFoundException e) {
            throw new NotExecutableException();
        }
        catch (ItemNotFoundException e) {
            throw new NotExecutableException();
        }
        finally {
            session2.logout();
        }
    }

    public void testSetSamePropertyTwice() throws RepositoryException {
        Node node = this.testRootNode.addNode("test");
        Session session = node.getSession();
        node.setProperty("prop", "value1");
        node.setProperty("prop", "value2");
        node.remove();
        session.save();
    }

    private String getAnotherWorkspace() throws NotExecutableException, RepositoryException {
        String srcWorkspace = this.getHelper().getProperty("org.apache.jackrabbit.jcr2spi.workspace2.name");
        if (srcWorkspace == null || srcWorkspace.equals(this.currentWorkspace)) {
            throw new NotExecutableException("no alternative workspace configured");
        }
        String[] accessible = this.testRootNode.getSession().getWorkspace().getAccessibleWorkspaceNames();
        for (int i = 0; i < accessible.length; ++i) {
            if (!accessible[i].equals(srcWorkspace)) continue;
            return srcWorkspace;
        }
        throw new NotExecutableException("configured workspace does not exist.");
    }
}

