/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import javax.jcr.ItemExistsException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.MoveTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class WorkspaceMoveTest
extends MoveTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected boolean isSessionMove() {
        return false;
    }

    @Override
    public void testMovePropertyExists() throws RepositoryException, NotExecutableException {
        Property destProperty;
        try {
            destProperty = this.destParentNode.setProperty(this.nodeName2, "anyString");
            this.destParentNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Cannot create property with name '" + this.nodeName2 + "' and value 'anyString' at move destination.");
        }
        if ("1.0".equals(this.getHelper().getRepository().getDescriptor("jcr.specification.version"))) {
            try {
                this.doMove(this.moveNode.getPath(), destProperty.getPath());
                WorkspaceMoveTest.fail((String)"Moving a node to a location where a property exists must throw ItemExistsException");
            }
            catch (ItemExistsException itemExistsException) {}
        } else {
            this.doMove(this.moveNode.getPath(), destProperty.getPath());
        }
    }

    public void testMoveTransientPropertyExists() throws RepositoryException, NotExecutableException {
        Property destProperty;
        try {
            destProperty = this.destParentNode.setProperty(this.nodeName2, "anyString");
        }
        catch (RepositoryException e) {
            throw new NotExecutableException("Cannot create property with name '" + this.nodeName2 + "' and value 'anyString' at move destination.");
        }
        this.doMove(this.moveNode.getPath(), destProperty.getPath());
        if ("1.0".equals(this.getHelper().getRepository().getDescriptor("jcr.specification.version"))) {
            try {
                this.destParentNode.save();
                WorkspaceMoveTest.fail((String)"Saving new transient property must fail");
            }
            catch (RepositoryException repositoryException) {}
        } else {
            this.destParentNode.save();
        }
    }
}

