/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Arrays;
import java.util.List;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceTest
extends AbstractJCRTest {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceTest.class);

    private static String getNewWorkspaceName(Workspace wsp) throws RepositoryException {
        List<String> names = Arrays.asList(wsp.getAccessibleWorkspaceNames());
        int index = 0;
        while (names.contains("testWsp_" + index)) {
            ++index;
        }
        return "testWsp_" + index;
    }

    public void testCreateWorkspace() throws Exception {
        Session s = null;
        try {
            Workspace wsp = this.superuser.getWorkspace();
            String name = WorkspaceTest.getNewWorkspaceName(wsp);
            wsp.createWorkspace(name);
            List<String> wsps = Arrays.asList(wsp.getAccessibleWorkspaceNames());
            WorkspaceTest.assertTrue((boolean)wsps.contains(name));
            s = this.getHelper().getSuperuserSession(name);
            Workspace newW = s.getWorkspace();
            WorkspaceTest.assertEquals((String)name, (String)newW.getName());
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new NotExecutableException();
        }
        catch (UnsupportedOperationException e) {
            throw new NotExecutableException();
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    public void testCreateWorkspaceFromSource() throws Exception {
        Session s = null;
        try {
            Workspace wsp = this.superuser.getWorkspace();
            String name = WorkspaceTest.getNewWorkspaceName(wsp);
            wsp.createWorkspace(name, wsp.getName());
            List<String> wsps = Arrays.asList(wsp.getAccessibleWorkspaceNames());
            WorkspaceTest.assertTrue((boolean)wsps.contains(name));
            s = this.getHelper().getSuperuserSession(name);
            Workspace newW = s.getWorkspace();
            WorkspaceTest.assertEquals((String)name, (String)newW.getName());
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new NotExecutableException();
        }
        catch (UnsupportedOperationException e) {
            throw new NotExecutableException();
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkspace() throws Exception {
        try {
            Workspace wsp = this.superuser.getWorkspace();
            String name = WorkspaceTest.getNewWorkspaceName(wsp);
            wsp.createWorkspace(name, wsp.getName());
            List<String> wsps = Arrays.asList(wsp.getAccessibleWorkspaceNames());
            WorkspaceTest.assertTrue((boolean)wsps.contains(name));
            wsp.deleteWorkspace(name);
            wsps = Arrays.asList(wsp.getAccessibleWorkspaceNames());
            WorkspaceTest.assertFalse((boolean)wsps.contains(name));
            Session s = null;
            try {
                s = this.getHelper().getSuperuserSession(name);
                WorkspaceTest.fail((String)(name + " has been deleted."));
            }
            catch (NoSuchWorkspaceException noSuchWorkspaceException) {
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new NotExecutableException();
        }
        catch (UnsupportedOperationException e) {
            throw new NotExecutableException();
        }
    }
}

