/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.benchmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.jcr2spi.AbstractJCR2SPITest;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.ItemInfoBuilder;
import org.apache.jackrabbit.spi.commons.ItemInfoCacheImpl;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.iterator.Predicate;

public class ReadPerformanceTest
extends AbstractJCR2SPITest {
    private static int TREE_DEPTH = 3;
    private static int NODE_COUNT = 6;
    private static int PROPERTY_COUNT = 60;
    private static int OP_COUNT = 500;
    private static int ITEM_INFO_CACHE_SIZE = 50000;
    private static int[] BATCH_RATIOS = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private final List<String> nodePaths = new ArrayList<String>();
    private final List<String> propertyPaths = new ArrayList<String>();
    private final Random rnd = new Random(12345L);
    private int roundTripCount;
    private int batchRatio;

    @Override
    public ItemInfoCache getItemInfoCache(SessionInfo sessionInfo) throws RepositoryException {
        return new ItemInfoCacheImpl(ITEM_INFO_CACHE_SIZE);
    }

    @Override
    protected void initInfosStore(ItemInfoBuilder.NodeInfoBuilder builder) throws RepositoryException {
        this.addNodes(builder, "");
    }

    private void addNodes(ItemInfoBuilder.NodeInfoBuilder builder, String name) throws RepositoryException {
        if (name.length() >= TREE_DEPTH) {
            builder.build();
            this.nodePaths.add(ReadPerformanceTest.toJCRPath(builder.getNodeInfo().getPath()));
            return;
        }
        for (int k = 0; k <= NODE_COUNT; ++k) {
            String n = name + k;
            this.addNodes(this.addProperties(builder.createNodeInfo(n), PROPERTY_COUNT), n);
        }
        builder.build();
    }

    private ItemInfoBuilder.NodeInfoBuilder addProperties(ItemInfoBuilder.NodeInfoBuilder builder, int count) throws RepositoryException {
        for (int k = 0; k < count; ++k) {
            ItemInfoBuilder.PropertyInfoBuilder pBuilder = builder.createPropertyInfo("property_" + k, "Just some string value " + k);
            pBuilder.build();
            this.propertyPaths.add(ReadPerformanceTest.toJCRPath(pBuilder.getPropertyInfo().getPath()));
        }
        return builder;
    }

    protected Iterable<Callable<Long>> getOperations(final Session session, int count) {
        ArrayList<Callable<Long>> callables = new ArrayList<Callable<Long>>();
        final ArrayList items = new ArrayList();
        block6: for (int k = 0; k < count; ++k) {
            switch (this.rnd.nextInt(4)) {
                case 0: {
                    callables.add(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            int i = ReadPerformanceTest.this.rnd.nextInt(ReadPerformanceTest.this.nodePaths.size() + ReadPerformanceTest.this.propertyPaths.size());
                            String path = i < ReadPerformanceTest.this.nodePaths.size() ? (String)ReadPerformanceTest.this.nodePaths.get(i) : (String)ReadPerformanceTest.this.propertyPaths.get(i - ReadPerformanceTest.this.nodePaths.size());
                            long t1 = System.currentTimeMillis();
                            Item item = session.getItem(path);
                            long t2 = System.currentTimeMillis();
                            items.add(item);
                            return t2 - t1;
                        }

                        public String toString() {
                            return "getItem";
                        }
                    });
                    continue block6;
                }
                case 1: {
                    callables.add(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            String path = (String)ReadPerformanceTest.this.nodePaths.get(ReadPerformanceTest.this.rnd.nextInt(ReadPerformanceTest.this.nodePaths.size()));
                            long t1 = System.currentTimeMillis();
                            Node node = session.getNode(path);
                            long t2 = System.currentTimeMillis();
                            items.add(node);
                            return t2 - t1;
                        }

                        public String toString() {
                            return "getNode";
                        }
                    });
                    continue block6;
                }
                case 2: {
                    callables.add(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            String path = (String)ReadPerformanceTest.this.propertyPaths.get(ReadPerformanceTest.this.rnd.nextInt(ReadPerformanceTest.this.propertyPaths.size()));
                            long t1 = System.currentTimeMillis();
                            Property property = session.getProperty(path);
                            long t2 = System.currentTimeMillis();
                            items.add(property);
                            return t2 - t1;
                        }

                        public String toString() {
                            return "getProperty";
                        }
                    });
                    continue block6;
                }
                case 3: {
                    callables.add(new Callable<Long>(){

                        @Override
                        public Long call() throws Exception {
                            if (items.isEmpty()) {
                                return 0L;
                            }
                            Item item = (Item)items.get(ReadPerformanceTest.this.rnd.nextInt(items.size()));
                            long t1 = System.currentTimeMillis();
                            item.refresh(ReadPerformanceTest.this.rnd.nextBoolean());
                            long t2 = System.currentTimeMillis();
                            return t2 - t1;
                        }

                        public String toString() {
                            return "refresh";
                        }
                    });
                    continue block6;
                }
                default: {
                    ReadPerformanceTest.fail((String)"Invalid case in switch");
                }
            }
        }
        return callables;
    }

    public void testReadOperations() throws Exception {
        for (int ratio : BATCH_RATIOS) {
            this.testReadOperations(OP_COUNT, ratio);
        }
    }

    private void testReadOperations(int opCount, int batchRatio) throws Exception {
        this.batchRatio = batchRatio;
        this.roundTripCount = 0;
        HashMap<String, Integer> opCounts = new HashMap<String, Integer>();
        HashMap<String, Long> opTimes = new HashMap<String, Long>();
        Session session = this.repository.login();
        Iterable<Callable<Long>> operations = this.getOperations(session, opCount);
        for (Callable<Long> operation : operations) {
            String opName = operation.toString();
            Long t = operation.call();
            if (opCounts.containsKey(opName)) {
                opCounts.put(opName, (Integer)opCounts.get(opName) + 1);
                opTimes.put(opName, (Long)opTimes.get(opName) + t);
                continue;
            }
            opCounts.put(opName, 1);
            opTimes.put(opName, t);
        }
        System.out.println("Batch ratio: " + batchRatio);
        System.out.println("Round trips: " + this.roundTripCount);
        int count = 0;
        long time = 0L;
        for (String opName : opCounts.keySet()) {
            int c = (Integer)opCounts.get(opName);
            count += c;
            System.out.println(opName + " count: " + c);
            long t = (Long)opTimes.get(opName);
            time += t;
            System.out.println(opName + " time: " + t);
        }
        System.out.println("Total count: " + count);
        System.out.println("Total time: " + time);
        session.logout();
    }

    private Iterator<ItemInfo> getBatch() {
        return Iterators.filterIterator(this.itemInfoStore.getItemInfos(), (Predicate)new Predicate<ItemInfo>(){

            public boolean evaluate(ItemInfo value) {
                return ReadPerformanceTest.this.rnd.nextInt(ReadPerformanceTest.this.batchRatio) == 0;
            }
        });
    }

    @Override
    protected QNodeDefinition createRootNodeDefinition() {
        ReadPerformanceTest.fail((String)"not implemented: createRootNodeDefinition");
        return null;
    }

    @Override
    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        ++this.roundTripCount;
        ItemInfo itemInfo = this.itemInfoStore.getItemInfo(itemId);
        return Iterators.iteratorChain((Iterator)Iterators.singleton((Object)itemInfo), this.getBatch());
    }

    @Override
    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        ++this.roundTripCount;
        return this.itemInfoStore.getNodeInfo(nodeId);
    }

    @Override
    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws ItemNotFoundException {
        ++this.roundTripCount;
        return this.itemInfoStore.getPropertyInfo(propertyId);
    }

    @Override
    public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws ItemNotFoundException, RepositoryException {
        ++this.roundTripCount;
        return this.itemInfoStore.getChildInfos(parentId);
    }
}

