/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.lock;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLockTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(AbstractLockTest.class);
    Node lockedNode;
    Node childNode;
    Lock lock;
    Session otherSession;

    abstract boolean isSessionScoped();

    protected void setUp() throws Exception {
        super.setUp();
        this.otherSession = this.getHelper().getSuperuserSession();
        this.lockedNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.lockedNode.addMixin(this.mixLockable);
        this.childNode = this.lockedNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        this.lock = this.lockedNode.lock(false, this.isSessionScoped());
    }

    protected void tearDown() throws Exception {
        try {
            this.lockedNode.unlock();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (this.otherSession.isLive()) {
            this.otherSession.logout();
            this.otherSession = null;
        }
        this.lockedNode = null;
        this.childNode = null;
        this.lock = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentChildLock() throws Exception {
        this.childNode.addMixin(this.mixLockable);
        this.testRootNode.save();
        try {
            this.childNode.lock(false, this.isSessionScoped());
            this.lockedNode.unlock();
            AbstractLockTest.assertTrue((String)"child node must still hold lock", (this.childNode.isLocked() && this.childNode.holdsLock() ? 1 : 0) != 0);
        }
        finally {
            this.childNode.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParentChildLock2() throws Exception {
        this.childNode.addMixin(this.mixLockable);
        this.testRootNode.save();
        try {
            Lock l = this.childNode.lock(false, this.isSessionScoped());
            AbstractLockTest.assertTrue((String)"child node must still hold lock", (boolean)l.getNode().isSame((Item)this.childNode));
        }
        finally {
            this.childNode.unlock();
        }
    }

    public void testCheckedInUnlock() throws Exception {
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Repository does not support versioning.");
        }
        this.lockedNode.addMixin(this.mixVersionable);
        this.lockedNode.save();
        this.lockedNode.checkin();
        this.lockedNode.unlock();
        AbstractLockTest.assertFalse((String)"Could not unlock a locked, checked-in node", (boolean)this.lockedNode.holdsLock());
    }

    public void testReorder() throws Exception {
        this.testRootNode.addNode(this.nodeName2);
        this.testRootNode.addNode(this.nodeName3);
        this.testRootNode.save();
        this.testRootNode.orderBefore(this.lockedNode.getName(), this.nodeName3);
        this.testRootNode.save();
        AbstractLockTest.assertTrue((String)"Node must remain locked upon reordering", (boolean)this.testRootNode.getNode(this.lockedNode.getName()).isLocked());
    }

    public void testReorderSNS() throws Exception {
        this.testRootNode.addNode(this.nodeName1);
        this.testRootNode.addNode(this.nodeName1);
        this.testRootNode.save();
        AbstractLockTest.assertTrue((String)"First child node locked", (boolean)this.testRootNode.getNode(this.nodeName1 + "[1]").isLocked());
        this.testRootNode.orderBefore(this.nodeName1 + "[1]", null);
        this.testRootNode.save();
        AbstractLockTest.assertTrue((String)"Third child node locked", (boolean)this.testRootNode.getNode(this.nodeName1 + "[3]").isLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveLocked() throws Exception {
        Session session = this.testRootNode.getSession();
        this.childNode.addMixin(this.mixLockable);
        this.childNode.save();
        try {
            this.childNode.lock(false, this.isSessionScoped());
            AbstractLockTest.assertTrue((String)"Child node locked", (boolean)this.childNode.isLocked());
            String newPath = this.testRootNode.getPath() + "/" + this.childNode.getName();
            session.move(this.childNode.getPath(), newPath);
            AbstractLockTest.assertTrue((String)"Child node locked before save", (boolean)this.childNode.isLocked());
            session.save();
            AbstractLockTest.assertTrue((String)"Child node locked after save", (boolean)this.childNode.isLocked());
        }
        finally {
            session.refresh(false);
            this.childNode.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnlockSameNameSibling() throws RepositoryException {
        Session session = this.testRootNode.getSession();
        Node lockedNode2 = this.testRootNode.addNode(this.nodeName1);
        lockedNode2.addMixin("mix:lockable");
        session.save();
        lockedNode2.lock(false, this.isSessionScoped());
        try {
            AbstractLockTest.assertTrue((String)"First node locked: ", (boolean)this.lockedNode.isLocked());
            AbstractLockTest.assertTrue((String)"Second node locked: ", (boolean)lockedNode2.isLocked());
        }
        catch (RepositoryException e) {
            this.lockedNode.unlock();
            lockedNode2.unlock();
            throw new RepositoryException((Throwable)e);
        }
        try {
            this.lockedNode.unlock();
            AbstractLockTest.assertFalse((String)"First node unlocked: ", (boolean)this.lockedNode.isLocked());
            AbstractLockTest.assertTrue((String)"Second node locked: ", (boolean)lockedNode2.isLocked());
        }
        finally {
            lockedNode2.unlock();
        }
    }

    public void testUnlockByOtherSession() throws RepositoryException {
        Node ln2 = (Node)this.otherSession.getItem(this.lockedNode.getPath());
        Lock l2 = ln2.getLock();
        this.lockedNode.unlock();
        AbstractLockTest.assertFalse((String)"Lock must be informed if Node is unlocked.", (boolean)l2.isLive());
    }

    public void testUnlockByOtherSession2() throws RepositoryException {
        Node ln2 = (Node)this.otherSession.getItem(this.lockedNode.getPath());
        this.lockedNode.unlock();
        AbstractLockTest.assertFalse((String)"Node is not locked any more", (boolean)ln2.isLocked());
        AbstractLockTest.assertFalse((String)"Node is not locked any more", (boolean)ln2.holdsLock());
        try {
            ln2.getLock();
            AbstractLockTest.fail((String)"Node is not locked any more");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testRemoveLockedNode() throws RepositoryException {
        Node n = (Node)this.otherSession.getItem(this.lockedNode.getPath());
        n.remove();
        this.otherSession.save();
    }
}

