/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.lock;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepLockTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(DeepLockTest.class);
    private final boolean isSessionScoped = false;
    private final boolean isDeep = true;
    private Node lockedNode;
    private Node childNode;
    private Lock lock;

    protected void setUp() throws Exception {
        super.setUp();
        this.lockedNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.lockedNode.addMixin(this.mixLockable);
        this.childNode = this.lockedNode.addNode(this.nodeName2, this.testNodeType);
        this.testRootNode.save();
        this.lock = this.lockedNode.lock(true, false);
    }

    protected void tearDown() throws Exception {
        try {
            this.lockedNode.unlock();
        }
        catch (RepositoryException e) {
            log.warn(e.getMessage());
        }
        this.lockedNode = null;
        this.childNode = null;
        this.lock = null;
        super.tearDown();
    }

    public void testLockHoldingNode() throws RepositoryException {
        DeepLockTest.assertTrue((String)"Lock.getNode() must be lockholding node.", (boolean)this.lock.getNode().isSame((Item)this.lockedNode));
    }

    public void testLockIsDeep() throws RepositoryException {
        DeepLockTest.assertTrue((String)"Lock.isDeep() if lock has been created deeply.", (boolean)this.lock.isDeep());
    }

    public void testNodeIsLocked() throws RepositoryException {
        DeepLockTest.assertTrue((String)"Creating a deep lock must create a lock on the lock-holding node", (boolean)this.lockedNode.isLocked());
        DeepLockTest.assertTrue((String)"Creating a deep lock must create a lock on the lock-holding node", (boolean)this.lockedNode.holdsLock());
    }

    public void testIsLockedChild() throws RepositoryException {
        DeepLockTest.assertTrue((String)"Child node below deep lock must be locked", (boolean)this.childNode.isLocked());
    }

    public void testIsLockedNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        DeepLockTest.assertTrue((String)"Child node below deep lock must be locked even if its is NEW", (boolean)newChild.isLocked());
    }

    public void testNotHoldsLockChild() throws RepositoryException {
        DeepLockTest.assertFalse((String)"Child node below deep lock must not be lock holder", (boolean)this.childNode.holdsLock());
    }

    public void testGetLockOnChild() throws RepositoryException {
        this.childNode.getLock();
    }

    public void testGetLockOnNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        newChild.getLock();
    }

    public void testGetNodeOnLockObtainedFromChild() throws RepositoryException {
        Lock lock = this.childNode.getLock();
        DeepLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node even if lock is obtained from child node.", (boolean)lock.getNode().isSame((Item)this.lockedNode));
    }

    public void testGetNodeOnLockObtainedFromNewChild() throws RepositoryException {
        Node newChild = this.lockedNode.addNode(this.nodeName3, this.testNodeType);
        Lock lock = newChild.getLock();
        DeepLockTest.assertTrue((String)"Lock.getNode() must return the lock holding node even if lock is obtained from child node.", (boolean)lock.getNode().isSame((Item)this.lockedNode));
    }

    public void testParentChildDeepLock() throws RepositoryException {
        this.childNode.addMixin(this.mixLockable);
        this.testRootNode.save();
        try {
            this.childNode.lock(false, false);
            DeepLockTest.fail((String)"child node is already locked by deep lock on parent.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    public void testDeepLockAboveLockedChild() throws RepositoryException, NotExecutableException {
        try {
            Node parent = this.lockedNode.getParent();
            if (!parent.isNodeType(this.mixLockable)) {
                try {
                    parent.addMixin(this.mixLockable);
                    parent.save();
                }
                catch (RepositoryException e) {
                    throw new NotExecutableException();
                }
            }
            parent.lock(true, false);
            DeepLockTest.fail((String)"Creating a deep lock on a parent of a locked node must fail.");
        }
        catch (LockException lockException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLockedChild() throws RepositoryException {
        Session otherSession = this.getHelper().getReadWriteSession();
        try {
            Node child = (Node)otherSession.getItem(this.childNode.getPath());
            child.remove();
            otherSession.save();
            DeepLockTest.fail((String)"A node below a deeply locked node cannot be removed by another Session.");
        }
        catch (LockException lockException) {
        }
        finally {
            otherSession.logout();
        }
    }
}

