/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.jackrabbit.jcr2spi.lock.AbstractLockTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenScopedLockTest
extends AbstractLockTest {
    private static Logger log = LoggerFactory.getLogger(OpenScopedLockTest.class);

    @Override
    boolean isSessionScoped() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogoutHasNoEffect() throws Exception {
        Node testRoot2 = (Node)this.otherSession.getItem(this.testRootNode.getPath());
        Node lockedNode2 = testRoot2.addNode(this.nodeName2, this.testNodeType);
        lockedNode2.addMixin(this.mixLockable);
        testRoot2.save();
        Lock lock2 = lockedNode2.lock(false, this.isSessionScoped());
        this.testRootNode.refresh(false);
        Node n2 = (Node)this.superuser.getItem(lockedNode2.getPath());
        try {
            String lockToken = lock2.getLockToken();
            this.otherSession.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
            this.otherSession.logout();
            OpenScopedLockTest.assertTrue((String)"After logout a open-scoped node must still be locked.", (boolean)lock2.isLive());
            OpenScopedLockTest.assertTrue((String)"After logout a open-scoped node must still be locked.", (boolean)n2.isLocked());
        }
        finally {
            n2.unlock();
        }
    }

    public void testLockTokenPresentWithSession() throws RepositoryException {
        String token = this.lock.getLockToken();
        String[] allTokens = this.lockedNode.getSession().getLockTokens();
        for (int i = 0; i < allTokens.length; ++i) {
            if (!allTokens[i].equals(token)) continue;
            return;
        }
        OpenScopedLockTest.fail((String)"Upon successful call to Node.lock, the lock token must automatically be added to the set of tokens held by the Session.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTokenTransfer() throws Exception {
        String lockToken = this.lock.getLockToken();
        try {
            this.superuser.removeLockToken(lockToken);
            String nlt = this.lock.getLockToken();
            OpenScopedLockTest.assertTrue((String)"freshly obtained lock token must either be null or the same as the one returned earlier", (nlt == null || nlt.equals(lockToken) ? 1 : 0) != 0);
        }
        finally {
            this.superuser.addLockToken(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshAfterTokenTransfer() throws Exception {
        String lockToken = this.lock.getLockToken();
        try {
            this.superuser.removeLockToken(lockToken);
            this.lock.refresh();
            OpenScopedLockTest.fail((String)"After transfering lock token the original lock object cannot be refresh by session, that does hold lock any more.");
        }
        catch (LockException lockException) {
        }
        finally {
            this.superuser.addLockToken(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshAfterTokenTransfer2() throws Exception {
        String lockToken = this.lock.getLockToken();
        Node n2 = (Node)this.otherSession.getItem(this.lockedNode.getPath());
        try {
            this.superuser.removeLockToken(lockToken);
            this.otherSession.addLockToken(lockToken);
            n2.getLock().refresh();
        }
        finally {
            this.otherSession.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockHolderAfterTokenTransfer() throws Exception {
        String lockToken = this.lock.getLockToken();
        Node n2 = (Node)this.otherSession.getItem(this.lockedNode.getPath());
        try {
            this.superuser.removeLockToken(lockToken);
            this.otherSession.addLockToken(lockToken);
            OpenScopedLockTest.assertTrue((String)"After lockToken transfer, the new lockHolder must get a non-null token", (n2.getLock().getLockToken() != null ? 1 : 0) != 0);
            OpenScopedLockTest.assertTrue((String)"After lockToken transfer, the new lockHolder must get the same token.", (boolean)n2.getLock().getLockToken().equals(lockToken));
        }
        finally {
            this.otherSession.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnlockAfterTokenTransfer() throws Exception {
        String lockToken = this.lock.getLockToken();
        try {
            this.superuser.removeLockToken(lockToken);
            this.lockedNode.unlock();
            OpenScopedLockTest.fail((String)"After transfering lock token the original lock object cannot be unlocked by session, that does hold lock any more.");
        }
        catch (LockException lockException) {
        }
        finally {
            this.superuser.addLockToken(lockToken);
        }
    }

    public void testUnlockAfterTokenTransfer2() throws Exception {
        String lockToken = this.lock.getLockToken();
        try {
            this.superuser.removeLockToken(lockToken);
            this.otherSession.addLockToken(lockToken);
            Node n2 = (Node)this.otherSession.getItem(this.lockedNode.getPath());
            n2.unlock();
        }
        catch (RepositoryException e) {
            this.otherSession.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
            throw e;
        }
    }

    public void testUnlockAfterTokenTransfer3() throws Exception {
        String lockToken = this.lock.getLockToken();
        try {
            this.superuser.removeLockToken(lockToken);
            this.otherSession.addLockToken(lockToken);
            Node n2 = (Node)this.otherSession.getItem(this.lockedNode.getPath());
            n2.unlock();
            OpenScopedLockTest.assertFalse((String)"Lock has been release by another session.", (boolean)this.lockedNode.holdsLock());
            OpenScopedLockTest.assertFalse((String)"Lock has been release by another session.", (boolean)this.lock.isLive());
            OpenScopedLockTest.assertFalse((String)"Lock has been release by another session.", (boolean)this.lock.getNode().isLocked());
            try {
                this.lockedNode.getLock();
                OpenScopedLockTest.fail((String)"Lock has been release by another session.");
            }
            catch (LockException lockException) {}
        }
        catch (RepositoryException e) {
            this.otherSession.removeLockToken(lockToken);
            this.superuser.addLockToken(lockToken);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLockedWhileAnotherLockIsPresent() throws Exception {
        String l2path;
        String l2token;
        block5: {
            Session s = this.lockedNode.getSession();
            LockManager lm = s.getWorkspace().getLockManager();
            l2token = null;
            l2path = null;
            String path = this.lockedNode.getPath();
            String lockToken = this.lock.getLockToken();
            OpenScopedLockTest.assertTrue((boolean)lm.isLocked(path));
            OpenScopedLockTest.assertTrue((boolean)lm.holdsLock(path));
            lm.removeLockToken(lockToken);
            Session anotherSession = null;
            try {
                anotherSession = this.getHelper().getSuperuserSession();
                LockManager anotherLockManager = anotherSession.getWorkspace().getLockManager();
                OpenScopedLockTest.assertTrue((boolean)anotherLockManager.isLocked(path));
                OpenScopedLockTest.assertTrue((boolean)anotherLockManager.holdsLock(path));
                Node l2node = anotherSession.getNode(path).getParent().addNode("second-lock");
                l2node.addMixin("{http://www.jcp.org/jcr/mix/1.0}lockable");
                anotherSession.save();
                l2path = l2node.getPath();
                Lock l2 = anotherLockManager.lock(l2path, false, false, Long.MAX_VALUE, "foobar");
                l2token = l2.getLockToken();
                OpenScopedLockTest.assertNotNull((Object)l2token);
                anotherSession.save();
                anotherSession.refresh(false);
                OpenScopedLockTest.assertTrue((boolean)anotherLockManager.isLocked(path));
                OpenScopedLockTest.assertTrue((boolean)anotherLockManager.holdsLock(path));
                anotherLockManager.addLockToken(lockToken);
                anotherLockManager.unlock(path);
                anotherSession.save();
                anotherLockManager.unlock(l2path);
                anotherSession.save();
                l2path = null;
                if (anotherSession == null) break block5;
            }
            catch (Throwable throwable) {
                if (anotherSession != null) {
                    anotherSession.logout();
                }
                if (l2path != null && l2token != null) {
                    this.superuser.refresh(false);
                    LockManager sulm = this.superuser.getWorkspace().getLockManager();
                    sulm.addLockToken(l2token);
                    sulm.unlock(l2path);
                }
                throw throwable;
            }
            anotherSession.logout();
        }
        if (l2path != null && l2token != null) {
            this.superuser.refresh(false);
            LockManager sulm = this.superuser.getWorkspace().getLockManager();
            sulm.addLockToken(l2token);
            sulm.unlock(l2path);
        }
    }
}

