/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.name;

import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceRegistryTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(NamespaceRegistryTest.class);
    private static final String TEST_PREFIX = "test";
    private static final String TEST_URI = "http://www.apache.org/jackrabbit/test/namespaceRegistryTest";
    private NamespaceRegistry nsRegistry;
    private String testPrefix;
    private String testURI;

    protected void setUp() throws Exception {
        super.setUp();
        this.nsRegistry = this.superuser.getWorkspace().getNamespaceRegistry();
        this.testPrefix = this.getUnusedPrefix();
        this.testURI = this.getUnusedURI();
        boolean level2 = Boolean.valueOf(this.superuser.getRepository().getDescriptor("level.2.supported"));
        if (!level2) {
            throw new NotExecutableException("Cannot test namespace registration/unregistration. Repository is a Level 1 only.");
        }
    }

    protected void tearDown() throws Exception {
        this.nsRegistry = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisteredNamespaceVisibility() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            NamespaceRegistry other = otherSession.getWorkspace().getNamespaceRegistry();
            this.nsRegistry.registerNamespace(this.testPrefix, this.testURI);
            String otherUri = other.getURI(this.testPrefix);
            String otherPrefix = other.getPrefix(this.testURI);
            NamespaceRegistryTest.assertTrue((String)"Namespace registered must be immediately visible to any other session.", (this.testURI.equals(otherUri) && this.testPrefix.equals(otherPrefix) ? 1 : 0) != 0);
        }
        finally {
            otherSession.logout();
        }
    }

    public void testReRegisteredNamespace() throws RepositoryException {
        this.nsRegistry.registerNamespace(this.testPrefix, this.testURI);
        String replacePrefix = this.getUnusedPrefix();
        this.nsRegistry.registerNamespace(replacePrefix, this.testURI);
        try {
            this.nsRegistry.getURI(this.testPrefix);
            NamespaceRegistryTest.fail((String)("Namespace with prefix " + this.testPrefix + " has been reregistered with new prefix " + replacePrefix));
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReRegisteredNamespace2() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            NamespaceRegistry other = otherSession.getWorkspace().getNamespaceRegistry();
            this.nsRegistry.registerNamespace(this.testPrefix, this.testURI);
            other.getPrefix(this.testURI);
            String replacePrefix = this.getUnusedPrefix();
            this.nsRegistry.registerNamespace(replacePrefix, this.testURI);
            String otherPrefix = other.getPrefix(this.testURI);
            NamespaceRegistryTest.assertEquals((String)("Namespace with prefix " + this.testPrefix + " has been reregistered with new prefix " + replacePrefix), (String)replacePrefix, (String)otherPrefix);
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReRegisteredNamespaceVisibility() throws RepositoryException {
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            NamespaceRegistry other = otherSession.getWorkspace().getNamespaceRegistry();
            this.nsRegistry.registerNamespace(this.testPrefix, this.testURI);
            other.getPrefix(this.testURI);
            String replacePrefix = this.getUnusedPrefix();
            this.nsRegistry.registerNamespace(replacePrefix, this.testURI);
            String otherUri = other.getURI(replacePrefix);
            String otherPrefix = other.getPrefix(this.testURI);
            NamespaceRegistryTest.assertTrue((String)"Namespace registered must be immediately visible to any other session.", (this.testURI.equals(otherUri) && replacePrefix.equals(otherPrefix) ? 1 : 0) != 0);
            try {
                other.getURI(this.testPrefix);
                NamespaceRegistryTest.fail((String)("Namespace with prefix " + this.testPrefix + " has been reregistered with new prefix " + replacePrefix));
            }
            catch (NamespaceException namespaceException) {
                // empty catch block
            }
        }
        finally {
            otherSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnregisteredNamespaceVisibility() throws RepositoryException, NotExecutableException {
        String prefix = this.getUnusedPrefix();
        String uri = this.getUnusedURI();
        Session otherSession = this.getHelper().getReadOnlySession();
        try {
            NamespaceRegistry other = otherSession.getWorkspace().getNamespaceRegistry();
            this.nsRegistry.registerNamespace(prefix, uri);
            try {
                this.nsRegistry.unregisterNamespace(prefix);
            }
            catch (NamespaceException e) {
                throw new NotExecutableException("Repository does not support unregistration of namespaces.");
            }
            String otherUri = other.getURI(prefix);
            String otherPrefix = other.getPrefix(uri);
            NamespaceRegistryTest.assertTrue((String)"Namespace registered must be immediately visible to any other session.", (uri.equals(otherUri) && prefix.equals(otherPrefix) ? 1 : 0) != 0);
        }
        finally {
            otherSession.logout();
        }
    }

    private String getUnusedPrefix() throws RepositoryException {
        HashSet<String> prefixes = new HashSet<String>(Arrays.asList(this.nsRegistry.getPrefixes()));
        String prefix = TEST_PREFIX;
        int i = 0;
        while (prefixes.contains(prefix)) {
            prefix = TEST_PREFIX + i++;
        }
        return prefix;
    }

    private String getUnusedURI() throws RepositoryException {
        HashSet<String> uris = new HashSet<String>(Arrays.asList(this.nsRegistry.getURIs()));
        String uri = TEST_URI;
        int i = 0;
        while (uris.contains(uri)) {
            uri = TEST_URI + i++;
        }
        return uri;
    }
}

