/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMixinTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(AddMixinTest.class);
    private NodeTypeManager ntMgr;

    protected void setUp() throws Exception {
        super.setUp();
        this.ntMgr = this.testRootNode.getSession().getWorkspace().getNodeTypeManager();
    }

    protected void tearDown() throws Exception {
        this.testRootNode.refresh(false);
        this.ntMgr = null;
        super.tearDown();
    }

    public void testAddMixinToNewNode() throws NotExecutableException, RepositoryException {
        Node newNode;
        try {
            newNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            newNode.addMixin(this.mixReferenceable);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        AddMixinTest.assertFalse((String)"Mixin must not be active before Node has been saved.", (boolean)newNode.isNodeType(this.mixReferenceable));
        NodeType[] mixins = newNode.getMixinNodeTypes();
        for (int i = 0; i < mixins.length; ++i) {
            if (!mixins[i].getName().equals(this.testNodeType)) continue;
            AddMixinTest.fail((String)"Mixin must not be active before Node has been saved.");
        }
    }

    public void testImplicitMixinOnNewNode() throws NotExecutableException, RepositoryException {
        Node newNode;
        try {
            String ntResource = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/nt/1.0") + ":resource";
            newNode = this.testRootNode.addNode(this.nodeName1, ntResource);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        AddMixinTest.assertFalse((String)"Implict Mixin inherited by primary Nodetype must not be active before Node has been saved.", (boolean)newNode.isNodeType(this.mixReferenceable));
        NodeType[] mixins = newNode.getMixinNodeTypes();
        for (int i = 0; i < mixins.length; ++i) {
            if (!mixins[i].getName().equals(this.testNodeType)) continue;
            AddMixinTest.fail((String)"Implict Mixin inherited by primary Nodetype must not be active before Node has been saved.");
        }
    }

    public void testAddMultipleAtOnce() throws NotExecutableException, RepositoryException {
        Node node;
        try {
            node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            node.addMixin(this.mixReferenceable);
            node.addMixin(this.mixLockable);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        AddMixinTest.assertTrue((String)"Adding 2 mixins at once -> both must be present.", (node.isNodeType(this.mixReferenceable) && node.isNodeType(this.mixLockable) ? 1 : 0) != 0);
    }

    public void testAddMultipleAtOnce2() throws NotExecutableException, RepositoryException {
        Node node;
        try {
            node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            node.addMixin(this.mixReferenceable);
            node.addMixin(this.mixLockable);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        List<NodeType> mixins = Arrays.asList(node.getMixinNodeTypes());
        AddMixinTest.assertTrue((String)"Adding 2 mixins at once -> both must be present.", (mixins.contains(this.ntMgr.getNodeType(this.mixReferenceable)) && mixins.contains(this.ntMgr.getNodeType(this.mixLockable)) ? 1 : 0) != 0);
    }

    public void testAddMultipleSeparately() throws NotExecutableException, RepositoryException {
        Node node;
        try {
            node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            node.addMixin(this.mixReferenceable);
            this.testRootNode.save();
            node.addMixin(this.mixLockable);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        AddMixinTest.assertTrue((String)"Adding 2 mixins at once -> both must be present.", (node.isNodeType(this.mixReferenceable) && node.isNodeType(this.mixLockable) ? 1 : 0) != 0);
        List<NodeType> mixins = Arrays.asList(node.getMixinNodeTypes());
        AddMixinTest.assertTrue((String)"Adding 2 mixins at once -> both must be present.", (mixins.contains(this.ntMgr.getNodeType(this.mixReferenceable)) && mixins.contains(this.ntMgr.getNodeType(this.mixLockable)) ? 1 : 0) != 0);
    }

    public void testAddItemsDefinedByMixin() throws NotExecutableException, RepositoryException {
        NodeTypeManager ntm = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntd = ntm.createNodeTypeTemplate();
        ntd.setName("testMixin");
        ntd.setMixin(true);
        NodeDefinitionTemplate nodeDef = ntm.createNodeDefinitionTemplate();
        nodeDef.setName("child");
        nodeDef.setRequiredPrimaryTypeNames(new String[]{"nt:folder"});
        ntd.getNodeDefinitionTemplates().add(nodeDef);
        ntm.registerNodeType((NodeTypeDefinition)ntd, true);
        Node node = this.testRootNode.addNode(this.nodeName1, "nt:resource");
        node.setProperty("jcr:data", "abc");
        node.addMixin("testMixin");
        this.superuser.save();
        node.addNode("child", "nt:folder");
        node.save();
    }

    public void testAddItemsDefinedByMixin2() throws NotExecutableException, RepositoryException {
        NodeTypeManager ntm = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntd = ntm.createNodeTypeTemplate();
        ntd.setName("testMixin");
        ntd.setMixin(true);
        NodeDefinitionTemplate nodeDef = ntm.createNodeDefinitionTemplate();
        nodeDef.setName("child");
        nodeDef.setRequiredPrimaryTypeNames(new String[]{"nt:folder"});
        ntd.getNodeDefinitionTemplates().add(nodeDef);
        ntm.registerNodeType((NodeTypeDefinition)ntd, true);
        Node node = this.testRootNode.addNode(this.nodeName1, "nt:resource");
        node.setProperty("jcr:data", "abc");
        node.addMixin("testMixin");
        this.superuser.save();
        try {
            node.addNode("child");
            AddMixinTest.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testAddItemsDefinedByMixin3() throws NotExecutableException, RepositoryException {
        NodeTypeManager ntm = this.superuser.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntd = ntm.createNodeTypeTemplate();
        ntd.setName("testMixin");
        ntd.setMixin(true);
        NodeDefinitionTemplate nodeDef = ntm.createNodeDefinitionTemplate();
        nodeDef.setName("child");
        nodeDef.setRequiredPrimaryTypeNames(new String[]{"nt:folder"});
        nodeDef.setDefaultPrimaryTypeName("nt:folder");
        ntd.getNodeDefinitionTemplates().add(nodeDef);
        ntm.registerNodeType((NodeTypeDefinition)ntd, true);
        Node node = this.testRootNode.addNode(this.nodeName1, "nt:resource");
        node.setProperty("jcr:data", "abc");
        node.addMixin("testMixin");
        this.superuser.save();
        Node c = node.addNode("child");
        AddMixinTest.assertEquals((String)"nt:folder", (String)c.getPrimaryNodeType().getName());
        this.superuser.save();
    }
}

