/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MandatoryItemTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(MandatoryItemTest.class);
    private NodeDefinition childNodeDef;
    private PropertyDefinition childPropDef;

    protected void setUp() throws Exception {
        super.setUp();
        NodeType nt = this.superuser.getWorkspace().getNodeTypeManager().getNodeType(this.testNodeType);
        NodeDefinition[] ndefs = nt.getChildNodeDefinitions();
        for (int i = 0; i < ndefs.length; ++i) {
            if (!ndefs[i].isMandatory() || ndefs[i].isProtected() || ndefs[i].isAutoCreated()) continue;
            this.childNodeDef = ndefs[i];
            break;
        }
        PropertyDefinition[] pdefs = nt.getPropertyDefinitions();
        for (int i = 0; i < pdefs.length; ++i) {
            if (!pdefs[i].isMandatory() || pdefs[i].isProtected() || pdefs[i].isAutoCreated()) continue;
            this.childPropDef = pdefs[i];
            break;
        }
        if (this.childPropDef == null && this.childNodeDef == null) {
            this.cleanUp();
            throw new NotExecutableException();
        }
    }

    public void testCreation() throws NotExecutableException, RepositoryException {
        Node n;
        try {
            n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        try {
            this.testRootNode.save();
            MandatoryItemTest.fail((String)"Saving without having added the mandatory child items must fail.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        if (this.childNodeDef != null) {
            n.addNode(this.childNodeDef.getName(), this.childNodeDef.getDefaultPrimaryType().getName());
        }
        if (this.childPropDef != null) {
            n.setProperty(this.childPropDef.getName(), "any value");
        }
        this.testRootNode.save();
    }

    public void testRemoval() throws NotExecutableException, RepositoryException {
        Node n;
        Node childN = null;
        Property childP = null;
        try {
            n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            if (this.childNodeDef != null) {
                childN = n.addNode(this.childNodeDef.getName(), this.childNodeDef.getDefaultPrimaryType().getName());
            }
            if (this.childPropDef != null) {
                childP = n.setProperty(this.childPropDef.getName(), "any value");
            }
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        if (childN != null) {
            childN.remove();
        }
        if (childP != null) {
            childP.remove();
        }
        try {
            this.testRootNode.save();
            MandatoryItemTest.fail((String)"removing mandatory child items without re-adding them must fail.");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        if (this.childNodeDef != null) {
            childN = n.addNode(this.childNodeDef.getName(), this.childNodeDef.getDefaultPrimaryType().getName());
        }
        if (this.childPropDef != null) {
            childP = n.setProperty(this.childPropDef.getName(), "any value");
        }
        this.testRootNode.save();
    }
}

