/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeTypeImplTest
extends AbstractJCRTest {
    private NodeTypeManager ntMgr;
    private NodeTypeImpl nodeType;
    private NameResolver resolver;

    protected void setUp() throws Exception {
        super.setUp();
        this.ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
        NodeType nt = this.ntMgr.getNodeType(this.testNodeType);
        if (!(nt instanceof NodeTypeImpl)) {
            this.cleanUp();
            throw new NotExecutableException("NodeTypeImpl expected.");
        }
        this.nodeType = (NodeTypeImpl)nt;
        if (!(this.superuser instanceof NameResolver)) {
            this.cleanUp();
            throw new NotExecutableException();
        }
        this.resolver = (NameResolver)this.superuser;
    }

    public void testIsNodeType() throws RepositoryException {
        NodeType[] superTypes = this.nodeType.getSupertypes();
        for (int i = 0; i < superTypes.length; ++i) {
            String name = superTypes[i].getName();
            NodeTypeImplTest.assertTrue((boolean)this.nodeType.isNodeType(this.resolver.getQName(name)));
        }
        String unknownName = "unknown";
        NodeTypeImplTest.assertFalse((boolean)this.nodeType.isNodeType(unknownName));
        if (!this.nodeType.isMixin()) {
            NodeTypeImplTest.assertTrue((boolean)this.nodeType.isNodeType("nt:base"));
        }
    }
}

