/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeManagerImplTest
extends AbstractJCRTest {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeManagerImplTest.class);
    private NodeTypeManager ntMgr;

    protected void setUp() throws Exception {
        super.setUp();
        this.ntMgr = this.superuser.getWorkspace().getNodeTypeManager();
    }

    public void testRegisterNodeTypes() throws RepositoryException {
        NodeTypeTemplate test = this.ntMgr.createNodeTypeTemplate();
        test.setName("testNodeType");
        this.ntMgr.registerNodeType((NodeTypeDefinition)test, true);
        NodeType nt = this.ntMgr.getNodeType("testNodeType");
        NodeTypeManagerImplTest.assertNotNull((Object)nt);
        NodeTypeManagerImplTest.assertEquals((String)"testNodeType", (String)nt.getName());
        test.setOrderableChildNodes(true);
        this.ntMgr.registerNodeType((NodeTypeDefinition)test, true);
        nt = this.ntMgr.getNodeType("testNodeType");
        NodeTypeManagerImplTest.assertNotNull((Object)nt);
        NodeTypeManagerImplTest.assertEquals((String)"testNodeType", (String)nt.getName());
        NodeTypeManagerImplTest.assertEquals((boolean)test.hasOrderableChildNodes(), (boolean)nt.hasOrderableChildNodes());
        test.setDeclaredSuperTypeNames(new String[]{"nt:unstructured"});
        try {
            this.ntMgr.registerNodeType((NodeTypeDefinition)test, false);
            NodeTypeManagerImplTest.fail((String)"NodeTypeExistsException expected");
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    public void testUnregisterNodeTypes() throws RepositoryException {
        boolean supported;
        block6: {
            NodeTypeTemplate test = this.ntMgr.createNodeTypeTemplate();
            test.setName("testNodeType2");
            this.ntMgr.registerNodeType((NodeTypeDefinition)test, true);
            NodeType nt = this.ntMgr.getNodeType("testNodeType2");
            NodeTypeManagerImplTest.assertNotNull((Object)nt);
            NodeTypeManagerImplTest.assertEquals((String)"testNodeType2", (String)nt.getName());
            supported = false;
            try {
                this.ntMgr.unregisterNodeType(test.getName());
                supported = true;
            }
            catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            }
            catch (RepositoryException e) {
                if (e.getMessage().contains("not yet implemented")) break block6;
                throw e;
            }
        }
        if (supported) {
            try {
                this.ntMgr.getNodeType("testNodeType2");
                NodeTypeManagerImplTest.fail((String)"should not be available any more");
            }
            catch (NoSuchNodeTypeException noSuchNodeTypeException) {
                // empty catch block
            }
        }
    }
}

