/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.nodetype;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveMixinTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(RemoveMixinTest.class);
    private NodeTypeManager ntMgr;

    protected void setUp() throws Exception {
        super.setUp();
        this.ntMgr = this.testRootNode.getSession().getWorkspace().getNodeTypeManager();
    }

    protected void tearDown() throws Exception {
        this.ntMgr = null;
        super.tearDown();
    }

    public void testRemoveMixinTakingAffectUponSave() throws NotExecutableException, RepositoryException {
        Node node;
        try {
            node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            node.addMixin(this.mixReferenceable);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        node.removeMixin(this.mixReferenceable);
        RemoveMixinTest.assertTrue((String)"Removing Mixin must not take effect but after Node has been saved.", (boolean)node.isNodeType(this.mixReferenceable));
        List<NodeType> mixins = Arrays.asList(node.getMixinNodeTypes());
        RemoveMixinTest.assertTrue((String)"Removing Mixin must not take effect but after Node has been saved.", (boolean)mixins.contains(this.ntMgr.getNodeType(this.mixReferenceable)));
    }

    public void testAddAndRemoveMixinFromNew() throws NotExecutableException, RepositoryException {
        Node node;
        try {
            node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            node.addMixin(this.mixReferenceable);
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        node.removeMixin(this.mixReferenceable);
        this.testRootNode.save();
        RemoveMixinTest.assertFalse((String)"Adding + Removing a mixin within the same batch must have not effect.", (boolean)node.isNodeType(this.mixReferenceable));
        List<NodeType> mixins = Arrays.asList(node.getMixinNodeTypes());
        RemoveMixinTest.assertFalse((String)"Adding + Removing a mixin within the same batch must have not effect.", (boolean)mixins.contains(this.ntMgr.getNodeType(this.mixReferenceable)));
    }

    public void testAddAndRemoveMixin() throws NotExecutableException, RepositoryException {
        Node node;
        try {
            node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            throw new NotExecutableException();
        }
        node.addMixin(this.mixReferenceable);
        node.removeMixin(this.mixReferenceable);
        this.testRootNode.save();
        RemoveMixinTest.assertFalse((String)"Adding + Removing a mixin within the same batch must have not effect.", (boolean)node.isNodeType(this.mixReferenceable));
        List<NodeType> mixins = Arrays.asList(node.getMixinNodeTypes());
        RemoveMixinTest.assertFalse((String)"Adding + Removing a mixin within the same batch must have not effect.", (boolean)mixins.contains(this.ntMgr.getNodeType(this.mixReferenceable)));
    }
}

