/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import junit.framework.Assert;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationTest
extends AbstractJCRTest {
    private static Logger log = LoggerFactory.getLogger(ObservationTest.class);
    private Node testNode;

    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1);
        this.testRootNode.save();
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJCR_2293() throws RepositoryException, InterruptedException {
        final String parentPath = this.testNode.getPath();
        final String folderName = "folder_" + System.currentTimeMillis();
        Session session = this.getHelper().getReadWriteSession();
        final Session session2 = this.getHelper().getReadOnlySession();
        session2.getItem(parentPath);
        WaitableEventListener eventListener = new WaitableEventListener(){
            private RepositoryException failure;
            private boolean done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void onEvent(EventIterator events) {
                try {
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        Item item2 = session2.getItem(event.getPath());
                        Assert.assertEquals((String)(parentPath + "/" + folderName), (String)item2.getPath());
                    }
                }
                catch (RepositoryException e) {
                    this.failure = e;
                }
                finally {
                    this.done = true;
                    this.notifyAll();
                }
            }

            @Override
            public synchronized void waitForEvent(int timeout) throws InterruptedException, RepositoryException {
                if (!this.done) {
                    this.wait(timeout);
                }
                if (!this.done) {
                    Assert.fail((String)"Event listener not called");
                }
                if (this.failure != null) {
                    throw this.failure;
                }
            }
        };
        session2.getWorkspace().getObservationManager().addEventListener((EventListener)eventListener, 1, parentPath, true, null, null, false);
        Node parent = (Node)session.getItem(parentPath);
        Node toDelete = parent.addNode(folderName, "nt:folder");
        parent.save();
        try {
            eventListener.waitForEvent(60000);
        }
        finally {
            toDelete.remove();
            parent.save();
            ObservationTest.assertFalse((boolean)parent.hasNode(folderName));
        }
    }

    static interface WaitableEventListener
    extends EventListener {
        public void waitForEvent(int var1) throws InterruptedException, RepositoryException;
    }
}

